package com.xdja.plugin.shadow.nonedynamic.utils;

import com.tencent.shadow.core.common.InstalledApk;
import com.xdja.plugin.shadow.nonedynamic.bean.InstalledApkInfo;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/20 <br/>
 */
public class ConvertUtil {

    /**
     * 转换
     *
     * @param installedApk
     * @return
     */
    public static InstalledApkInfo convert(InstalledApk installedApk) {
        if (installedApk == null) {
            return null;
        }
        InstalledApkInfo info = new InstalledApkInfo(installedApk.apkFilePath,
                installedApk.oDexPath,
                installedApk.libraryPath,
                installedApk.parcelExtras);
        return info;
    }

    /**
     * 转换
     *
     * @param info
     * @return
     */
    public static InstalledApk convert(InstalledApkInfo info) {
        if (info == null) {
            return null;
        }
        InstalledApk installedApk = new InstalledApk(info.apkFilePath,
                info.oDexPath,
                info.libraryPath,
                info.parcelExtras);
        return installedApk;
    }
}
