package com.xdja.plugin.shadow.nonedynamic.utils;

import android.content.Context;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/13 <br/>
 */
public class FileUtil {
    /**
     * 得到文件的crc32值
     *
     * @param file
     * @return
     */
    public static String getCrc32(File file) {
        String result = "";
        if (!file.exists()) {
            return result;
        }

        try {
            FileInputStream fis = new FileInputStream(file);
            final int bufferLen = 8 * 1024;
            byte[] buffer = new byte[bufferLen];
            int len;
            CRC32 crc = new CRC32();
            while ((len = fis.read(buffer)) > 0) {
                if (len == bufferLen) {
                    crc.update(buffer);
                } else {
                    crc.update(Arrays.copyOf(buffer, len));
                }
            }
            result = "" + crc.getValue();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 将so库copy出来
     *
     * @param context
     * @param pluginFile
     * @return
     */
    public static String extraSo(Context context, File pluginFile, File soDir) {
        if (!soDir.exists()) {
            soDir.mkdirs();
        }

        String filter = getFilter(context);
        ZipEntry zipEntry = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(pluginFile));
            ArrayList<String> libList = new ArrayList<>();

            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (entryName.startsWith("lib/")) {
                    libList.add(entryName);
                }
                continue;
            }
            zipInputStream.closeEntry();

            String flagStr = "lib/arm64-v8a/";
            if ("arm".equals(filter)) {
                boolean flag = false;
                for (String name : libList) {
                    if (name.startsWith("lib/armeabi-v7a/")) {
                        flag = true;
                        break;
                    }
                }
                if (flag) {
                    flagStr = "lib/armeabi-v7a/";
                } else {
                    flagStr = "lib/armeabi/";
                }
            }

            zipInputStream = new ZipInputStream(new FileInputStream(pluginFile));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String name = zipEntry.getName();
                if (name.startsWith(flagStr)) {
                    BufferedOutputStream output = null;
                    try {
                        String fileName = name.substring(flagStr.length());
                        File file = new File(soDir, fileName);
                        output = new BufferedOutputStream(
                                new FileOutputStream(file));
                        BufferedInputStream input = new BufferedInputStream(zipInputStream);
                        final int bufferLen = 8 * 1024;
                        byte[] b = new byte[bufferLen];
                        int n;
                        while ((n = input.read(b, 0, bufferLen)) >= 0) {
                            output.write(b, 0, n);
                        }
                    } finally {
                        zipInputStream.closeEntry();
                        if (output != null) {
                            output.close();
                        }
                    }
                }
            }
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getFilter(Context context) {
        String nativeLibraryDir = context.getApplicationInfo().nativeLibraryDir;
        File file = new File(nativeLibraryDir);
        return file.getName();
    }

    /**
     * 删除file
     *
     * @param file
     */
    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            deleteDirWihtFile(file);
        } else {
            file.delete();
        }
    }


    private static void deleteDirWihtFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                deleteDirWihtFile(file);
            }
        }
        dir.delete();
    }
}
