package com.xdja.plugin.shadow.nonedynamic.utils;

import android.text.TextUtils;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/13 <br/>
 */
public class Utils {
    /**
     * 判断两个版本的大小.<br>
     * true：current大；
     * false：installed大；
     *
     * @param current
     * @param installed
     * @return
     */
    public static boolean judgeVersion(String current, String installed) {
        if (TextUtils.isEmpty(current)) {
            return false;
        }

        if (TextUtils.isEmpty(installed)) {
            return true;
        }

        String[] currentSplit = current.split("\\.");
        String[] installedSplit = installed.split("\\.");
        int currentLen = currentSplit.length;
        int installedLen = installedSplit.length;
        int i = 0;
        for (; (i < currentLen && i < installedLen); i++) {
            Integer c = Integer.valueOf(currentSplit[i]);
            Integer ii = Integer.valueOf(installedSplit[i]);
            if (c > ii) {
                return true;
            }
        }

        if ((i == currentLen) && (currentLen < installedLen)) {
            return false;
        }

        return true;
    }
}
