/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.plugin.shadow.nonedynamic;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcel;
import android.os.StrictMode;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.shadow.core.common.ILoggerFactory;
import com.tencent.shadow.core.common.InstalledApk;
import com.tencent.shadow.core.common.LoggerFactory;
import com.tencent.shadow.core.load_parameters.LoadParameters;
import com.tencent.shadow.core.loader.ShadowPluginLoader;
import com.tencent.shadow.core.runtime.container.ContentProviderDelegateProvider;
import com.tencent.shadow.core.runtime.container.ContentProviderDelegateProviderHolder;
import com.tencent.shadow.core.runtime.container.DelegateProvider;
import com.tencent.shadow.core.runtime.container.DelegateProviderHolder;
import com.xdja.plugin.shadow.nonedynamic.XdjaComponentManager;
import com.xdja.plugin.shadow.nonedynamic.XdjaLoggerFactory;
import com.xdja.plugin.shadow.nonedynamic.XdjaPluginContainerProvider;
import com.xdja.plugin.shadow.nonedynamic.XdjaPluginLoader;
import com.xdja.plugin.shadow.nonedynamic.bean.InstalledShadowPluginInfo;
import com.xdja.plugin.shadow.nonedynamic.storage.StorageInstalledPlugin;
import com.xdja.plugin.shadow.nonedynamic.utils.ApkParser;
import com.xdja.plugin.shadow.nonedynamic.utils.ConvertUtil;
import com.xdja.plugin.shadow.nonedynamic.utils.FileUtil;
import com.xdja.plugin.shadow.nonedynamic.utils.PkgInfoUtil;
import com.xdja.plugin.shadow.nonedynamic.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;

public class ShadowManager {
    private static final String PATH_PLUGIN = "ShadowNoneDynamicPlugin";
    private static ShadowManager instance;
    private ShadowPluginLoader mPluginLoader;
    private Context context;
    ExecutorService cachedThreadPool = Executors.newCachedThreadPool();

    private ShadowManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShadowManager getInstance() {
        if (instance != null) return instance;
        Class<ShadowManager> clazz = ShadowManager.class;
        synchronized (ShadowManager.class) {
            if (instance != null) return instance;
            instance = new ShadowManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
        this.mPluginLoader = new XdjaPluginLoader(context);
        XdjaPluginLoader loader = this.mPluginLoader;
        loader.onCreate();
        DelegateProviderHolder.setDelegateProvider((String)loader.getDelegateProviderKey(), (DelegateProvider)loader);
        ContentProviderDelegateProviderHolder.setContentProviderDelegateProvider((ContentProviderDelegateProvider)loader);
    }

    public ArrayList<InstalledShadowPluginInfo> getAll() {
        ArrayList<InstalledShadowPluginInfo> all = StorageInstalledPlugin.getAll(this.context);
        return all;
    }

    public int uninstall(String partKey) {
        if (TextUtils.isEmpty((CharSequence)partKey)) {
            return -1;
        }
        InstalledShadowPluginInfo plugin = StorageInstalledPlugin.get(this.context, partKey);
        if (plugin == null) {
            return -1;
        }
        StorageInstalledPlugin.delete(this.context, partKey);
        File path = new File(this.context.getFilesDir(), PATH_PLUGIN);
        File dir = new File(path, "/" + partKey + "/" + plugin.version);
        FileUtil.deleteFile(dir);
        return 0;
    }

    public int startPluginActivity(final String partKey, String activityName) {
        if (TextUtils.isEmpty((CharSequence)partKey)) {
            return -5;
        }
        final InstalledShadowPluginInfo plugin = StorageInstalledPlugin.get(this.context, partKey);
        if (plugin == null) {
            return -6;
        }
        final String startActivityName = TextUtils.isEmpty((CharSequence)activityName) ? plugin.mainActivityName : activityName;
        if (TextUtils.isEmpty((CharSequence)startActivityName)) {
            return -6;
        }
        if (this.mPluginLoader.getPluginParts(partKey) != null) {
            return this.startActivity(startActivityName);
        }
        this.cachedThreadPool.submit(new Callable<Integer>(){

            @Override
            public Integer call() {
                try {
                    ShadowManager.this.mPluginLoader.loadPlugin(ConvertUtil.convert(plugin.installedApk)).get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return -7;
                }
                ShadowManager.this.mPluginLoader.callApplicationOnCreate(partKey, XdjaPluginContainerProvider.getContentProvider());
                return ShadowManager.this.startActivity(startActivityName);
            }
        });
        return 0;
    }

    public int install(String partKey, String version, File pluginFile) {
        boolean flag;
        if (TextUtils.isEmpty((CharSequence)partKey) || TextUtils.isEmpty((CharSequence)version) || pluginFile == null || !pluginFile.exists()) {
            return -5;
        }
        InstalledShadowPluginInfo pluginInfo = StorageInstalledPlugin.get(this.context, partKey);
        if (pluginInfo != null && !(flag = Utils.judgeVersion(version, pluginInfo.version))) {
            return -8;
        }
        flag = this.judgePluginCanInstall(pluginFile);
        if (!flag) {
            return -9;
        }
        int ret = this.installPlugin(partKey, version, pluginFile);
        if (ret == 0) {
            this.notifyInstalledPlugin(partKey, version);
        }
        return ret;
    }

    private boolean judgePluginCanInstall(File pluginFile) {
        if (PkgInfoUtil.isApkInDebug(this.context)) {
            return true;
        }
        String pluginCert = PkgInfoUtil.getCertFingerStrFromApkFile(this.context, pluginFile.getAbsolutePath());
        String selfCert = PkgInfoUtil.getCertFingerStr(this.context, this.context.getPackageName());
        try {
            if (selfCert.equals(pluginCert)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private int installPlugin(String partKey, String version, File pluginFile) {
        File path = new File(this.context.getFilesDir(), PATH_PLUGIN);
        String hash = FileUtil.getCrc32(pluginFile);
        File dir = new File(path, "/" + partKey + "/" + version + "/" + hash);
        File objFile = new File(dir, "plugin.apk");
        File libDir = new File(dir, "lib");
        File oDexDir = new File(dir, "odex");
        oDexDir.mkdirs();
        try {
            String apkFilePath;
            File installedFileDir;
            String installedFileDirPath;
            FileUtils.copyFile((File)pluginFile, (File)objFile);
            FileUtil.extraSo(this.context, objFile, libDir);
            InstalledShadowPluginInfo installedPluginInfo = StorageInstalledPlugin.get(this.context, partKey);
            if (installedPluginInfo != null && !(installedFileDirPath = (installedFileDir = new File(apkFilePath = installedPluginInfo.installedApk.apkFilePath).getParentFile()).getAbsolutePath()).equals(dir.getAbsolutePath())) {
                FileUtil.deleteFile(installedFileDir);
            }
            LoadParameters loadParameters = new LoadParameters(null, partKey, null, null);
            Parcel parcel = Parcel.obtain();
            loadParameters.writeToParcel(parcel, 0);
            InstalledApk installedApk = new InstalledApk(objFile.getAbsolutePath(), oDexDir.getAbsolutePath(), libDir.getAbsolutePath(), parcel.marshall());
            InstalledShadowPluginInfo pluginInfo = new InstalledShadowPluginInfo(partKey, version, ConvertUtil.convert(installedApk));
            ApkParser apkParser = ApkParser.build(this.context, objFile.getAbsolutePath());
            if (apkParser != null) {
                pluginInfo.mainActivityName = apkParser.getMainActivityName();
                pluginInfo.info.put("activity", apkParser.getActivityList());
                pluginInfo.info.put("service", apkParser.getServiceList());
                pluginInfo.info.put("provider", apkParser.getProviderList());
                pluginInfo.info.put("receiver", apkParser.getReceiverList());
            }
            StorageInstalledPlugin.add(this.context, partKey, pluginInfo);
            parcel.recycle();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -10;
        }
    }

    private void notifyInstalledPlugin(String partKey, String version) {
        Log.e((String)"test", (String)(partKey + "_" + version + " : installed"));
    }

    private int startActivity(String activityName) {
        Intent pluginIntent = new Intent();
        pluginIntent.setClassName(this.context.getPackageName(), activityName);
        pluginIntent.putStringArrayListExtra("activities", XdjaComponentManager.sActivities);
        Intent intent = this.mPluginLoader.getMComponentManager().convertPluginActivityIntent(pluginIntent);
        if (!(this.context instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        this.context.startActivity(intent);
        return 0;
    }

    private static void detectNonSdkApiUsageOnAndroidP() {
        boolean isRunningEspressoTest;
        if (Build.VERSION.SDK_INT < 28) {
            return;
        }
        try {
            Class.forName("android.support.test.espresso.Espresso");
            isRunningEspressoTest = true;
        }
        catch (Exception ignored) {
            isRunningEspressoTest = false;
        }
        if (isRunningEspressoTest) {
            return;
        }
        StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder();
        builder.detectNonSdkApiUsage();
        StrictMode.setVmPolicy((StrictMode.VmPolicy)builder.build());
    }

    static {
        ShadowManager.detectNonSdkApiUsageOnAndroidP();
        LoggerFactory.setILoggerFactory((ILoggerFactory)new XdjaLoggerFactory());
    }
}

