/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.plugin.shadow.nonedynamic.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.AssetManager;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.text.TextUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class ApkParser {
    private Context context;
    String apkPath;
    private ArrayList<String> activityList = new ArrayList();
    private ArrayList<String> serviceList = new ArrayList();
    private ArrayList<String> receiverList = new ArrayList();
    private ArrayList<String> providerList = new ArrayList();
    private HashMap<String, IntentFilter> intentFilters = new HashMap();
    private String mainActivityName;
    private static final String ANDROID_RESOURCES = "http://schemas.android.com/apk/res/android";
    private static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";

    private ApkParser(Context context, String apkPath) {
        this.context = context;
        this.apkPath = apkPath;
    }

    public String getApkPath() {
        return this.apkPath;
    }

    public ArrayList<String> getActivityList() {
        return this.activityList;
    }

    public ArrayList<String> getServiceList() {
        return this.serviceList;
    }

    public ArrayList<String> getReceiverList() {
        return this.receiverList;
    }

    public ArrayList<String> getProviderList() {
        return this.providerList;
    }

    public HashMap<String, IntentFilter> getIntentFilters() {
        return this.intentFilters;
    }

    public String getMainActivityName() {
        return this.mainActivityName;
    }

    public static ApkParser build(Context context, String apkPath) {
        if (context == null || TextUtils.isEmpty((CharSequence)apkPath)) {
            return null;
        }
        ApkParser apkParser = new ApkParser(context, apkPath);
        apkParser.parse();
        return apkParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        AssetManager assetManager = null;
        XmlResourceParser parser = null;
        try {
            assetManager = (AssetManager)AssetManager.class.newInstance();
            Method method = AssetManager.class.getDeclaredMethod("addAssetPath", String.class);
            method.invoke((Object)assetManager, this.apkPath);
            parser = assetManager.openXmlResourceParser(ANDROID_MANIFEST_FILENAME);
            this.parseManifest(parser);
            parser.close();
            assetManager.close();
            parser = null;
            assetManager = null;
        }
        catch (Exception exception) {
        }
        finally {
            if (parser != null) {
                parser.close();
                parser = null;
            }
            if (assetManager != null) {
                assetManager.close();
                assetManager = null;
            }
        }
    }

    private void parseManifest(XmlResourceParser parser) throws Exception {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            String tagName;
            if (type == 3 || type == 4 || TextUtils.isEmpty((CharSequence)(tagName = parser.getName())) || !tagName.equals("activity") && !tagName.equals("receiver") && !tagName.equals("service") && !tagName.equals("provider") || TextUtils.isEmpty((CharSequence)(name = parser.getAttributeValue(ANDROID_RESOURCES, "name")))) continue;
            this.writeToList(tagName, name);
            this.parseIntentFilter(name, parser);
        }
    }

    private void writeToList(String tagName, String name) {
        if (tagName.equals("activity")) {
            this.activityList.add(name);
        } else if (tagName.equals("service")) {
            this.serviceList.add(name);
        } else if (tagName.equals("provider")) {
            this.providerList.add(name);
        } else if (tagName.equals("receiver")) {
            this.receiverList.add(name);
        }
    }

    private void parseIntentFilter(String name, XmlResourceParser parser) throws Exception {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || (tagName = parser.getName()) == null || !tagName.equals("intent-filter")) continue;
            IntentFilter mFilter = new IntentFilter();
            this.intentFilters.put(name, mFilter);
            this.parseIntentFilter(mFilter, parser);
            if (!TextUtils.isEmpty((CharSequence)this.mainActivityName)) continue;
            boolean mainFlag = mFilter.hasAction("android.intent.action.MAIN");
            boolean launcherFlag = mFilter.hasCategory("android.intent.category.LAUNCHER");
            if (!mainFlag || !launcherFlag) continue;
            this.mainActivityName = name;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void parseIntentFilter(IntentFilter mFilter, XmlResourceParser attrs) throws Exception {
        int type;
        int outerDepth = attrs.getDepth();
        while ((type = attrs.next()) != 1 && (type != 3 || attrs.getDepth() > outerDepth)) {
            String mimeType;
            String pathPattern;
            String pathPrefix;
            String path;
            String scheme;
            String value;
            String nodeName;
            if (type == 3 || type == 4 || (nodeName = attrs.getName()) == null) continue;
            if (nodeName.equals("action")) {
                value = attrs.getAttributeValue(ANDROID_RESOURCES, "name");
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                mFilter.addAction(value);
                continue;
            }
            if (nodeName.equals("category")) {
                value = attrs.getAttributeValue(ANDROID_RESOURCES, "name");
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                mFilter.addCategory(value);
                continue;
            }
            if (!nodeName.equals("data")) continue;
            String host = attrs.getAttributeValue(ANDROID_RESOURCES, "host");
            String port = attrs.getAttributeValue(ANDROID_RESOURCES, "port");
            if (!TextUtils.isEmpty((CharSequence)host) && !TextUtils.isEmpty((CharSequence)port)) {
                mFilter.addDataAuthority(host, port);
            }
            if (!TextUtils.isEmpty((CharSequence)(scheme = attrs.getAttributeValue(ANDROID_RESOURCES, "scheme")))) {
                mFilter.addDataScheme(scheme);
            }
            if (!TextUtils.isEmpty((CharSequence)(path = attrs.getAttributeValue(ANDROID_RESOURCES, "path")))) {
                mFilter.addDataPath(path, 0);
            }
            if (!TextUtils.isEmpty((CharSequence)(pathPrefix = attrs.getAttributeValue(ANDROID_RESOURCES, "pathPrefix")))) {
                mFilter.addDataPath(pathPrefix, 1);
            }
            if (!TextUtils.isEmpty((CharSequence)(pathPattern = attrs.getAttributeValue(ANDROID_RESOURCES, "pathPattern")))) {
                mFilter.addDataPath(pathPattern, 2);
            }
            if (!TextUtils.isEmpty((CharSequence)(mimeType = attrs.getAttributeValue(ANDROID_RESOURCES, "mimeType")))) {
                mFilter.addDataType(mimeType);
            }
            if (Build.VERSION.SDK_INT < 19) continue;
            String ssp = attrs.getAttributeValue(ANDROID_RESOURCES, "ssp");
            mFilter.addDataSchemeSpecificPart(ssp, 0);
            String sspPrefix = attrs.getAttributeValue(ANDROID_RESOURCES, "sspPrefix");
            mFilter.addDataSchemeSpecificPart(sspPrefix, 1);
            String sspPattern = attrs.getAttributeValue(ANDROID_RESOURCES, "sspPattern");
            mFilter.addDataSchemeSpecificPart(sspPattern, 2);
        }
    }
}

