/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.plugin.shadow.nonedynamic.utils;

import android.content.Context;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static String getCrc32(File file) {
        String result = "";
        if (!file.exists()) {
            return result;
        }
        try {
            int len;
            FileInputStream fis = new FileInputStream(file);
            int bufferLen = 8192;
            byte[] buffer = new byte[8192];
            CRC32 crc = new CRC32();
            while ((len = fis.read(buffer)) > 0) {
                if (len == 8192) {
                    crc.update(buffer);
                    continue;
                }
                crc.update(Arrays.copyOf(buffer, len));
            }
            result = "" + crc.getValue();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extraSo(Context context, File pluginFile, File soDir) {
        if (!soDir.exists()) {
            soDir.mkdirs();
        }
        String filter = FileUtil.getFilter(context);
        ZipEntry zipEntry = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(pluginFile));
            ArrayList<String> libList = new ArrayList<String>();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                if (!entryName.startsWith("lib/")) continue;
                libList.add(entryName);
            }
            zipInputStream.closeEntry();
            String flagStr = "lib/arm64-v8a/";
            if ("arm".equals(filter)) {
                boolean flag = false;
                for (String name : libList) {
                    if (!name.startsWith("lib/armeabi-v7a/")) continue;
                    flag = true;
                    break;
                }
                flagStr = flag ? "lib/armeabi-v7a/" : "lib/armeabi/";
            }
            zipInputStream = new ZipInputStream(new FileInputStream(pluginFile));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String name = zipEntry.getName();
                if (!name.startsWith(flagStr)) continue;
                FilterOutputStream output = null;
                try {
                    int n;
                    String fileName = name.substring(flagStr.length());
                    File file = new File(soDir, fileName);
                    output = new BufferedOutputStream(new FileOutputStream(file));
                    BufferedInputStream input = new BufferedInputStream(zipInputStream);
                    int bufferLen = 8192;
                    byte[] b = new byte[8192];
                    while ((n = input.read(b, 0, 8192)) >= 0) {
                        ((BufferedOutputStream)output).write(b, 0, n);
                    }
                }
                finally {
                    zipInputStream.closeEntry();
                    if (output == null) continue;
                    output.close();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String getFilter(Context context) {
        String nativeLibraryDir = context.getApplicationInfo().nativeLibraryDir;
        File file = new File(nativeLibraryDir);
        return file.getName();
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            FileUtil.deleteDirWihtFile(file);
        } else {
            file.delete();
        }
    }

    private static void deleteDirWihtFile(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isFile()) {
                file.delete();
                continue;
            }
            if (!file.isDirectory()) continue;
            FileUtil.deleteDirWihtFile(file);
        }
        dir.delete();
    }
}

