/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.plugin.shadow.nonedynamic.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class PkgInfoUtil {
    public static boolean isApkInDebug(Context context) {
        try {
            ApplicationInfo info = context.getApplicationInfo();
            return (info.flags & 2) != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getCertFingerStr(Context context, String pkgName) {
        try {
            PkgInfoUtil util = new PkgInfoUtil();
            X509Certificate cert = util.getSignCer(context, pkgName);
            return util.format(util.parseCerFingerprint(cert));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCertFingerStrFromApkFile(Context context, String apkPath) {
        try {
            PkgInfoUtil util = new PkgInfoUtil();
            X509Certificate cert = util.getSignCerFromApkFile(context, apkPath);
            return util.format(util.parseCerFingerprint(cert));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String format(String str) {
        StringBuffer localStringBuffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            localStringBuffer.append(str.charAt(i));
            if (i <= 0 || i % 2 != 1 || i >= str.length() - 1) continue;
            localStringBuffer.append(":");
        }
        return localStringBuffer.toString();
    }

    private X509Certificate getSignCerFromApkFile(Context context, String apkPath) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageArchiveInfo(apkPath, 64);
            Signature[] signs = packageInfo.signatures;
            Signature signature = signs[0];
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
            return cert;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private X509Certificate getSignCer(Context context, String packName) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packName, 64);
            Signature[] signs = packageInfo.signatures;
            Signature signature = signs[0];
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
            return cert;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String parseCerFingerprint(X509Certificate cert) {
        try {
            byte[] arrayOfByte = this.convert1(cert.getEncoded());
            return this.convert2(arrayOfByte);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
    }

    private byte[] convert1(byte[] data) {
        try {
            MessageDigest localMessageDigest = MessageDigest.getInstance("SHA1");
            return localMessageDigest.digest(data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private String convert2(byte[] data) {
        char[] arr = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(arr[(data[i] & 0xF0) >> 4]);
            sb.append(arr[data[i] & 0xF]);
        }
        return sb.toString();
    }
}

