package com.xdja.plugin.shadow.nonedynamic.bean;

import android.os.Parcel;
import android.os.Parcelable;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/13 <br/>
 */
public class InstalledShadowPluginInfo implements Parcelable {

    /**
     * 组件的唯一Id
     */
    public String partKey;
    /**
     * 版本号。
     * 格式需要是： x.x.x
     * 不过多少个小数点无所谓，但不能为负数，不能有字符。
     */
    public String version;
    /**
     * 安装完成的apk(Shadow框架定义的)
     */
    public InstalledApkInfo installedApk;
    /**
     * 四大组件信息
     * key是: activity，service，provider，receiver
     */
    public HashMap<String, ArrayList<String>> info = new HashMap<>();
    /**
     * 主Activity类名，有可能为空.
     */
    public String mainActivityName;

    /**
     * providerAuthority信息
     */
    public List<String> providerAuthorityList = new ArrayList<>();

    /**
     * 广播对应的action
     */
    public HashMap<String, String[]> receiverAction = new HashMap<>();

    public InstalledShadowPluginInfo() {
    }

    public InstalledShadowPluginInfo(String partKey, String version, InstalledApkInfo installedApk) {
        this.partKey = partKey;
        this.version = version;
        this.installedApk = installedApk;
    }

    protected InstalledShadowPluginInfo(Parcel in) {
        partKey = in.readString();
        version = in.readString();
        installedApk = in.readParcelable(InstalledApkInfo.class.getClassLoader());
        mainActivityName = in.readString();
    }

    public static final Creator<InstalledShadowPluginInfo> CREATOR = new Creator<InstalledShadowPluginInfo>() {
        @Override
        public InstalledShadowPluginInfo createFromParcel(Parcel in) {
            return new InstalledShadowPluginInfo(in);
        }

        @Override
        public InstalledShadowPluginInfo[] newArray(int size) {
            return new InstalledShadowPluginInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(partKey);
        dest.writeString(version);
        dest.writeParcelable(installedApk, flags);
        dest.writeString(mainActivityName);
    }
}
