package com.xdja.plugin.shadow.nonedynamic.jar;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Pair;

import com.xdja.plugin.shadow.nonedynamic.INoneDynamic;
import com.xdja.plugin.shadow.nonedynamic.bean.InstalledShadowPluginInfo;
import com.xdja.plugin.shadow.nonedynamic.param.ParamKeywords;

import java.io.File;
import java.util.List;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2020/2/14 <br/>
 */
public class JarShadowManager {

    private static JarShadowManager instance;

    private JarShadowManager(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    public static JarShadowManager getInstance(Context context) {
        if (instance == null) {
            synchronized (JarShadowManager.class) {
                if (instance == null) {
                    instance = new JarShadowManager(context);
                }
            }
        }
        return instance;
    }

    /**
     * 获取所有安装的插件
     *
     * @return
     */
    public Pair<Integer, List<InstalledShadowPluginInfo>> getAllInstalledPlugin() {
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_getAllInstalledPlugin);

        Pair<Integer, Bundle> pair = callForBundle(bundle);
        if (pair.first != 0) {
            return Pair.create(pair.first, null);
        }

        try {
            pair.second.setClassLoader(InstalledShadowPluginInfo.class.getClassLoader());
            int ret = getIntRet(pair);
            if (ret != 0) {
                return Pair.create(ret, null);
            }
            Bundle result = pair.second;
            List<InstalledShadowPluginInfo> allInstalledPlugin = result.getParcelableArrayList(ParamKeywords.KEY_ParcelableArrayList_allInstalledPlugin);
            return Pair.create(0, allInstalledPlugin);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Pair.create(ErrorCode.RET_EXCEPTION, null);
    }

    /**
     * 卸载插件
     *
     * @param partKey
     * @return
     */
    public int uninstallPlugin(String partKey) {
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_partKey, partKey);
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_uninstallPlugin);

        return getIntRet(callForBundle(bundle));
    }

    /**
     * 启动插件中的activity
     *
     * @param partKey
     * @param activityName
     * @return
     */
    public int startPluginActivity(final String partKey, final String activityName) {
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_partKey, partKey);
        bundle.putString(ParamKeywords.KEY_String_activityName, activityName);
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_startPluginActivity);

        return getIntRet(callForBundle(bundle));
    }

    /**
     * 启动插件中的activity
     *
     * @param partKey
     * @param activityName
     * @param extraBundle  给插件传递的参数
     * @return
     */
    public int startPluginActivity(final String partKey, final String activityName, Bundle extraBundle) {
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_partKey, partKey);
        bundle.putString(ParamKeywords.KEY_String_activityName, activityName);
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_startPluginActivity);
        bundle.putBundle(ParamKeywords.KEY_Bundle_extraBundle, extraBundle);
        return getIntRet(callForBundle(bundle));
    }

    /**
     * 安装插件
     *
     * @param pluginFile
     * @return
     */
    public int install(File pluginFile) {
        Bundle bundle = new Bundle();
        bundle.putString(ParamKeywords.KEY_String_pluginFilePath, pluginFile.getAbsolutePath());
        bundle.putString(ParamKeywords.KEY_String_method, ParamKeywords.KEY_METHOD_installPlugin);

        return getIntRet(callForBundle(bundle));
    }

    private Pair<Integer, Bundle> callForBundle(Bundle bundle) {
        Pair<Integer, INoneDynamic> pair = getBinder();
        if (pair.first != 0) {
            return Pair.create(pair.first, null);
        }
        INoneDynamic binder = pair.second;
        try {
            Bundle result = binder.call(bundle);
            if (result == null) {
                return Pair.create(ErrorCode.RET_CALL_SERVICE_FAIL, null);
            }
            result.setClassLoader(this.getClass().getClassLoader());
            return Pair.create(0, result);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return Pair.create(ErrorCode.RET_EXCEPTION, null);
    }

    private int getIntRet(Pair<Integer, Bundle> pair) {
        if (pair.first != 0) {
            return pair.first;
        }
        int ret = pair.second.getInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_EXCEPTION);
        return ret;
    }

    private INoneDynamic binder;
    private Context context;

    /**
     * 如果first不等于0，表示获取binder失败
     *
     * @return
     */
    private Pair<Integer, INoneDynamic> getBinder() {
        if (binder != null) {
            return Pair.create(0, binder);
        }
        ContentResolver resolver = context.getContentResolver();
        Bundle result = resolver.call(getUri(), ParamKeywords.KEY_METHOD_GetBinder, ParamKeywords.KEY_String_NoneDynamicBinder, null);
        if (result == null) {
            return Pair.create(ErrorCode.RET_CALL_SERVICE_FAIL, null);
        }
        int ret = result.getInt(ParamKeywords.KEY_int_ret, ErrorCode.RET_EXCEPTION);
        if (ret != 0) {
            return Pair.create(ret, null);
        }
        IBinder binder = result.getBinder(ParamKeywords.KEY_Binder_Binder);
        if (binder == null) {
            return null;
        }
        linkToDeath(binder);
        this.binder = INoneDynamic.Stub.asInterface(binder);
        return Pair.create(0, this.binder);
    }

    private void linkToDeath(IBinder binder) {
        try {
            binder.linkToDeath(new IBinder.DeathRecipient() {
                @Override
                public void binderDied() {
                    JarShadowManager.this.binder = null;
                }
            }, 0);
        } catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static Uri uri;
    private final static String DEFAULT_URI = ".nonedynamic.ShadowNoneDynamicPluginProvider.authority";

    private Uri getUri() {
        if (uri == null) {
            uri = Uri.parse("content://" + context.getPackageName() + DEFAULT_URI);
        }
        return uri;
    }

}
