/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication;

import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.Consts;
import com.xdja.prs.authentication.IPermissions;
import com.xdja.prs.authentication.sync.SyncHttpClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private AbstractPermissionContainer permissionContainer;
    private SyncHttpClient syncHttpClient;
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private ScheduledFuture<?> scheduledFuture;

    public AbstractSyncService(AbstractPermissionContainer permissionContainer, SyncHttpClient syncHttpClient) {
        this.permissionContainer = permissionContainer;
        this.syncHttpClient = syncHttpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        this.logger.info("\u5f00\u59cb\u540c\u6b65\u9274\u6743\u4fe1\u606f......");
        try {
            final IPermissions permissions = this.loadPermissionsFromDB();
            this.permissionContainer.updatePermissions(permissions);
            this.singleThreadExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractSyncService.this.syncHttpClient.sendForSync(AbstractSyncService.this.getAuthenticationType(), permissions);
                    }
                    catch (Exception e) {
                        AbstractSyncService.this.logger.error("\u5c06\u914d\u7f6e\u4fe1\u606f\u53d1\u9001\u7ed9\u8fdc\u7a0b\u51fa\u9519!", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error("\u5b9a\u65f6\u66f4\u65b0\u914d\u7f6e\u51fa\u9519!", (Throwable)e);
        }
        finally {
            this.logger.info("\u7ed3\u675f\u540c\u6b65\u9274\u6743\u4fe1\u606f......");
        }
    }

    protected abstract Consts.AuthenticationType getAuthenticationType();

    protected abstract IPermissions loadPermissionsFromDB();

    public void shutdown() {
        this.logger.info("SyncService shutdown....");
        this.singleThreadExecutor.shutdownNow();
        this.scheduledExecutorService.shutdownNow();
    }

    public void startup(int syncPeriod) {
        if (this.scheduledFuture != null) {
            throw new IllegalStateException("SyncService has already started\uff01\uff01\uff01");
        }
        this.logger.info("SyncService startup , sync period is {} ", (Object)syncPeriod);
        this.scheduledFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                AbstractSyncService.this.sync();
            }
        }, 0L, syncPeriod, TimeUnit.MILLISECONDS);
    }
}

