/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication;

import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.IAuthenticate;
import com.xdja.prs.authentication.gateway.GatewayProcess;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

class Authenticate
implements IAuthenticate {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private GatewayProcess gatewayProcess;
    private AbstractPermissionContainer permissionContainer;

    Authenticate(GatewayProcess gatewayProcess, AbstractPermissionContainer permissionContainer) {
        this.gatewayProcess = gatewayProcess;
        this.permissionContainer = permissionContainer;
    }

    @Override
    public boolean authenticate(Map<String, Object> context, String ip, int port, Object ... otherParams) {
        String identity = "";
        String identityType = "";
        String sn = null;
        boolean rst = false;
        this.logger.debug("begin authenticate for ip:{},port:{}", (Object)ip, (Object)port);
        if (this.gatewayProcess.isGatewayIp(ip)) {
            this.logger.debug("check gateway ip : true");
            sn = this.gatewayProcess.getSnByPort(ip, port);
        } else {
            this.logger.debug("check gateway ip : false");
            if (this.permissionContainer.isValidAppServerIp(ip, otherParams)) {
                this.logger.debug("check appServer ip : true");
                identity = ip;
                identityType = "ip";
                rst = true;
            } else {
                this.logger.debug("check appServer ip : false");
                sn = this.gatewayProcess.getSnByIp(ip);
            }
        }
        this.logger.debug("final sn is : {}", (Object)sn);
        if (StringUtils.hasText((String)sn)) {
            identity = sn;
            identityType = "sn";
            rst = this.permissionContainer.isValidSn(sn, otherParams);
        }
        if (context != null) {
            context.put("auth.identity", identity);
            context.put("auth.identityType", identityType);
        }
        return rst;
    }
}

