/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.xdja.prs.authentication.Consts;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Configs {
    private final Properties props;
    public static final String AUTH_AUTH_TYPE = "auth.authType";
    public static final String AUTH_NET_LOCATION = "auth.netLocation";
    public static final String AUTH_SYNC_PERIOD = "auth.syncPeriod";
    public static final String AUTH_GATEWAY_IP = "auth.gatewayIp";
    public static final String AUTH_GATEWAY_PORT = "auth.gatewayPort";
    public static final String AUTH_HTTP_PROXY_PORT = "auth.httpProxyPort";
    public static final String AUTH_HTTP_PROXY_IP = "auth.httpProxyIp";
    public static final String AUTH_SYNC_URL = "auth.syncUrl";
    public static final String AUTH_HTTP_PORT = "auth.httpPort";
    public static final String AUTH_GATEWAY_RECEIVE_PORT = "auth.gatewayReceivePort";

    public Configs(Properties props) {
        this.props = props;
    }

    public Properties getProps() {
        return this.props;
    }

    public Consts.AuthenticationType getAuthenticationType() {
        String property = this.props.getProperty(AUTH_AUTH_TYPE);
        Assert.hasText((String)property, (String)AUTH_AUTH_TYPE);
        Integer type = Ints.tryParse((String)property);
        if (type != null) {
            return Consts.AuthenticationType.indexOf(type.byteValue());
        }
        return Consts.AuthenticationType.valueOf(property.trim());
    }

    public Consts.NetLocation getNetLocation() {
        String property = this.props.getProperty(AUTH_NET_LOCATION);
        Assert.hasText((String)property, (String)AUTH_NET_LOCATION);
        Integer type = Ints.tryParse((String)property);
        if (type != null) {
            return Consts.NetLocation.indexOf(type.byteValue());
        }
        return Consts.NetLocation.valueOf(property.trim());
    }

    public int getSyncPeriod() {
        String property = this.props.getProperty(AUTH_SYNC_PERIOD);
        Assert.hasText((String)property, (String)AUTH_SYNC_PERIOD);
        return Integer.parseInt(property);
    }

    public int getGatewayReceivePort() {
        String property = this.props.getProperty(AUTH_GATEWAY_RECEIVE_PORT);
        Assert.hasText((String)property, (String)AUTH_GATEWAY_RECEIVE_PORT);
        return Integer.parseInt(property);
    }

    public int getHttpPort() {
        String property = this.props.getProperty(AUTH_HTTP_PORT);
        Assert.hasText((String)property, (String)AUTH_HTTP_PORT);
        return Integer.parseInt(property);
    }

    public List<String> getGatewayIpList() {
        ArrayList rst = Lists.newArrayList();
        String property = this.props.getProperty(AUTH_GATEWAY_IP);
        if (StringUtils.hasLength((String)property)) {
            String[] split;
            for (String tmp : split = property.trim().split(",")) {
                if (!StringUtils.hasLength((String)tmp)) continue;
                rst.add(tmp.trim());
            }
        }
        return rst;
    }

    public List<Integer> getGatewayPortList() {
        ArrayList rst = Lists.newArrayList();
        String property = this.props.getProperty(AUTH_GATEWAY_PORT);
        if (StringUtils.hasLength((String)property)) {
            String[] split;
            for (String tmp : split = property.trim().split(",")) {
                if (!StringUtils.hasLength((String)tmp)) continue;
                rst.add(Integer.parseInt(tmp.trim()));
            }
        }
        return rst;
    }

    public String getSyncUrl() {
        String property = this.props.getProperty(AUTH_SYNC_URL);
        Assert.hasText((String)property, (String)AUTH_SYNC_URL);
        return property;
    }

    public String getHttpProxyIp() {
        String property = this.props.getProperty(AUTH_HTTP_PROXY_IP);
        return property;
    }

    public Integer getHttpProxyPort() {
        String property = this.props.getProperty(AUTH_HTTP_PROXY_PORT);
        Assert.hasText((String)property, (String)AUTH_HTTP_PROXY_PORT);
        return Integer.parseInt(property);
    }
}

