/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.xdja.prs.authentication.support.csagent.AppUserArea;
import java.beans.PropertyVetoException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DataManager {
    private JdbcTemplate mdpJdbc;
    private JdbcTemplate prsJdbc;
    private JdbcTemplate pamsJdbc;

    public DataManager(Properties props) throws PropertyVetoException {
        this.mdpJdbc = this.initJdbcTemplate(props, "mdp");
        this.prsJdbc = this.initJdbcTemplate(props, "prs");
        this.pamsJdbc = this.initJdbcTemplate(props, "pams");
    }

    private JdbcTemplate initJdbcTemplate(Properties props, String tag) throws PropertyVetoException {
        String urlKey = "auth." + tag + ".jdbc.url";
        String url = props.getProperty(urlKey);
        Assert.hasText((String)url, (String)urlKey);
        String driverKey = "auth." + tag + ".jdbc.driver";
        String driver = props.getProperty(driverKey);
        Assert.hasText((String)driver, (String)driver);
        String usernameKey = "auth." + tag + ".jdbc.username";
        String username = props.getProperty(usernameKey);
        Assert.hasText((String)username, (String)usernameKey);
        String passwordKey = "auth." + tag + ".jdbc.password";
        String password = props.getProperty(passwordKey);
        Assert.hasText((String)password, (String)passwordKey);
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setDriverClass(driver);
        ds.setJdbcUrl(url);
        ds.setUser(username);
        ds.setPassword(password);
        ds.setMinPoolSize(1);
        ds.setMaxPoolSize(3);
        ds.setInitialPoolSize(1);
        ds.setMaxIdleTime(60);
        return new JdbcTemplate((DataSource)ds);
    }

    public Map<String, Set<String>> getIp2Group() {
        final HashMap ip2Group = Maps.newHashMap();
        String sql = "select ar.RES_GROUP_ID as groupid, a.SERVER_IP as ip from T_APP_RES ar left join T_APP a on ar.APP_ID=a.APP_ID where a.SERVER_IP is not null union select tar.RES_GROUP_ID as groupid, b.SERVER_IP as ip from T_TMP_APP_RES tar left join T_TMP_APP b on tar.APP_ID=b.APP_ID where b.SERVER_IP is not null and b.PUBLISH_STATUS='0' and b.APPLY_STATUS='1'";
        this.mdpJdbc.query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String groupId = rs.getString("groupId");
                String ip = rs.getString("ip");
                if (!ip2Group.containsKey(ip)) {
                    ip2Group.put(ip, Sets.newHashSet());
                }
                ((Set)ip2Group.get(ip)).add(groupId);
            }
        });
        return ip2Group;
    }

    public Map<String, Set<String>> getServerIp2ResMappings(Map<String, Set<String>> ip2Group) {
        HashMap ip2Res = Maps.newHashMap();
        String sql = "select RES_ID as rid from T_PRS_RESOURCE where RES_PKG_ID in (:resGroupIds)";
        for (String ip : ip2Group.keySet()) {
            Set<String> groupSet = ip2Group.get(ip);
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("resGroupIds", groupSet);
            List rids = this.prsJdbc.queryForList(sql, new Object[]{paramMap});
            groupSet.clear();
        }
        ip2Group.clear();
        return ip2Res;
    }

    public Map<String, Set<String>> getServerIp2TabMappings(Map<String, Set<String>> ip2Group) {
        HashMap ip2Tab = Maps.newHashMap();
        String sql = "select RES_LOCAL_TABLE_NAME as rLocTabName from T_PRS_RESOURCE where RES_PKG_ID in (:resGroupIds)";
        List tabList = Lists.newArrayList();
        Set<Object> groupSet = Sets.newHashSet();
        for (String ip : ip2Group.keySet()) {
            groupSet = ip2Group.get(ip);
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("resGroupIds", groupSet);
            tabList = this.prsJdbc.queryForList(sql, new Object[]{paramMap});
            tabList.clear();
            groupSet.clear();
        }
        ip2Group.clear();
        return ip2Tab;
    }

    public Map<String, Set<String>> getAppSnMappings() {
        final HashMap app2person = Maps.newHashMap();
        HashMap app2sn = Maps.newHashMap();
        final HashMap app2area = Maps.newHashMap();
        String sql = "select aua.APP_ID as appId,aua.Type as type,aua.AREA_ID as areaId from T_APP_USE_AREA aua union select taua.APP_ID as appId,taua.Type as type,taua.AREA_ID as areaId from T_TMP_APP_USE_AREA taua";
        this.mdpJdbc.query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String appId = rs.getString("appId");
                String type = rs.getString("type");
                String areaId = rs.getString("areaId");
                if ("person".equalsIgnoreCase(type)) {
                    DataManager.this.putPerson2App(app2person, appId, Arrays.asList(areaId));
                } else {
                    AppUserArea one = new AppUserArea(appId, type, areaId);
                    if (!app2area.containsKey(appId)) {
                        app2area.put(appId, Sets.newHashSet());
                    }
                    ((Set)app2area.get(appId)).add(one);
                }
            }
        });
        for (String app : app2area.keySet()) {
            Set conditions = (Set)app2area.get(app);
            Set<String> deptSet = this.getQueryDeptSet(conditions);
            String police = this.getQueryProperty(conditions, "police");
            String sex = this.getQueryProperty(conditions, "sex");
            ArrayList params = Lists.newArrayList();
            StringBuffer tmpSql = new StringBuffer("select id from T_PERSON where flag=0 ");
            if (!CollectionUtils.isEmpty(deptSet)) {
                tmpSql.append(" and dep_id in (?)");
                params.add(deptSet);
            }
            if (StringUtils.hasText((String)police)) {
                tmpSql.append(" and police=?");
                params.add(police);
            }
            if (StringUtils.hasText((String)sex)) {
                tmpSql.append(" and sex=?");
                params.add(sex);
            }
            List persons = this.pamsJdbc.queryForList(tmpSql.toString(), params.toArray(), String.class);
            this.putPerson2App(app2person, app, persons);
        }
        for (String app : app2person.keySet()) {
            Set persons = (Set)app2person.get(app);
            Set<String> sns = this.querySns(persons);
            app2sn.put(app, sns);
            persons.clear();
        }
        app2person.clear();
        return app2sn;
    }

    public Map<String, Set<String>> getAppResGroupMappings() {
        String sql = "select ar.RES_GROUP_ID as groupId,ar.APP_ID as app from T_APP_RES ar union select tar.RES_GROUP_ID as groupId,tar.APP_ID as app from T_TMP_APP_RES tar";
        final HashMap app2Group = Maps.newHashMap();
        this.mdpJdbc.query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String groupId = rs.getString("groupId");
                String app = rs.getString("app");
                if (!app2Group.containsKey(app)) {
                    app2Group.put(app, Sets.newHashSet());
                }
                ((Set)app2Group.get(app)).add(groupId);
            }
        });
        return app2Group;
    }

    public Map<String, Set<String>> getAppResMappings(Map<String, Set<String>> app2Group) {
        HashMap app2res = Maps.newHashMap();
        String sql = "select RES_ID as rid from T_PRS_RESOURCE where RES_PKG_ID in (?)";
        for (String app : app2Group.keySet()) {
            Set<String> groupSet = app2Group.get(app);
            List rids = this.prsJdbc.queryForList(sql, String.class, groupSet.toArray());
            app2res.put(app, Sets.newHashSet((Iterable)rids));
            groupSet.clear();
        }
        app2Group.clear();
        return app2res;
    }

    public Map<String, Set<String>> getAppTabMappings(Map<String, Set<String>> app2Group) {
        HashMap app2res = Maps.newHashMap();
        String sql = "select RES_LOCAL_TABLE_NAME as rLocTabName from T_PRS_RESOURCE where RES_PKG_ID in (?)";
        List tabList = Lists.newArrayList();
        for (String app : app2Group.keySet()) {
            Set<String> groupSet = app2Group.get(app);
            tabList = this.prsJdbc.queryForList(sql, String.class, groupSet.toArray());
            app2res.put(app, Sets.newHashSet((Iterable)tabList));
            tabList.clear();
            groupSet.clear();
        }
        app2Group.clear();
        return app2res;
    }

    private Set<String> querySns(Set<String> persons) {
        HashSet rst = Sets.newHashSet();
        String tmpSql = "select sn from T_DEVICE where state=3 and person_id in (?)";
        int flag = 0;
        HashSet param = Sets.newHashSet();
        for (String one : persons) {
            param.add(one);
            if (++flag % 100 != 0) continue;
            List sns = this.pamsJdbc.queryForList(tmpSql, String.class, param.toArray());
            rst.addAll(sns);
            param.clear();
        }
        return rst;
    }

    private String getQueryProperty(Set<AppUserArea> conditions, String type) {
        for (AppUserArea one : conditions) {
            if (!type.equalsIgnoreCase(one.getType())) continue;
            return one.getAreaId();
        }
        return null;
    }

    private Set<String> getQueryDeptSet(Set<AppUserArea> conditions) {
        String depId = this.getQueryProperty(conditions, "dep");
        if (StringUtils.hasText((String)depId)) {
            List ids = this.pamsJdbc.queryForList("select id from t_department start with id = ? connect by prior parent_id=id AND flag=0", String.class, new Object[]{depId});
            return Sets.newHashSet((Iterable)ids);
        }
        return Collections.EMPTY_SET;
    }

    private void putPerson2App(Map<String, Set<String>> app2person, String appId, Collection<String> persons) {
        if (!app2person.containsKey(appId)) {
            app2person.put(appId, Sets.newHashSet());
        }
        app2person.get(appId).addAll(persons);
    }

    public void closeDataSource() {
        for (JdbcTemplate one : Arrays.asList(this.mdpJdbc, this.prsJdbc, this.pamsJdbc)) {
            ComboPooledDataSource ds = (ComboPooledDataSource)one.getDataSource();
            ds.close();
        }
    }
}

