/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication;

import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.AbstractSyncService;
import com.xdja.prs.authentication.Authenticate;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.Consts;
import com.xdja.prs.authentication.IAuthenticate;
import com.xdja.prs.authentication.gateway.GatewayProcess;
import com.xdja.prs.authentication.support.csagent.CSPermissionContainer;
import com.xdja.prs.authentication.support.csagent.CSSyncService;
import com.xdja.prs.authentication.support.drs.DRSPermissionContainer;
import com.xdja.prs.authentication.support.drs.DRSSyncService;
import com.xdja.prs.authentication.sync.SyncHttpClient;
import com.xdja.prs.authentication.sync.SyncHttpServer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrsAuthentication {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SyncHttpServer syncHttpServer;
    private final GatewayProcess gatewayProcess;
    private final IAuthenticate authenticate;
    private AbstractSyncService syncService;

    public PrsAuthentication(Configs configs) throws Exception {
        Consts.AuthenticationType type = configs.getAuthenticationType();
        AbstractPermissionContainer permissionContainer = null;
        this.gatewayProcess = new GatewayProcess();
        this.logger.info("Current Authentication Type is {}", (Object)type);
        if (Consts.AuthenticationType.CSAGENT == type) {
            permissionContainer = new CSPermissionContainer();
        } else if (Consts.AuthenticationType.DRS == type) {
            permissionContainer = new DRSPermissionContainer();
        } else {
            throw new IllegalArgumentException("Unknow AuthenticationType : " + (Object)((Object)type));
        }
        Consts.NetLocation location = configs.getNetLocation();
        this.logger.info("Current Net Location is {}", (Object)location);
        if (Consts.NetLocation.SwitchIn == location) {
            this.syncHttpServer = new SyncHttpServer(permissionContainer);
            this.syncHttpServer.startup(configs.getHttpPort());
            List<String> gatewayIpList = configs.getGatewayIpList();
            List<Integer> gatewayPortList = configs.getGatewayPortList();
            if (gatewayIpList.size() != gatewayPortList.size() && gatewayPortList.size() != 1) {
                throw new IllegalArgumentException("\u7f51\u5173ip\u6570\u91cf\u4e0e\u7f51\u5173\u7aef\u53e3\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
            }
            this.gatewayProcess.startup(gatewayIpList, gatewayPortList, configs.getGatewayReceivePort());
        } else if (Consts.NetLocation.Intranet == location) {
            SyncHttpClient httpClient = new SyncHttpClient(configs.getSyncUrl(), configs.getHttpProxyIp(), configs.getHttpProxyPort());
            if (Consts.AuthenticationType.CSAGENT == type) {
                this.syncService = new CSSyncService(permissionContainer, httpClient, configs);
            } else if (Consts.AuthenticationType.DRS == type) {
                this.syncService = new DRSSyncService(permissionContainer, httpClient, configs);
            }
            this.syncService.startup(configs.getSyncPeriod());
        }
        this.authenticate = new Authenticate(this.gatewayProcess, permissionContainer);
    }

    public IAuthenticate getAuthenticate() {
        return this.authenticate;
    }

    public void stop() throws Exception {
        if (this.gatewayProcess != null) {
            this.gatewayProcess.shutdown();
        }
        if (this.syncHttpServer != null) {
            this.syncHttpServer.shutdown();
        }
        if (this.syncService != null) {
            this.syncService.shutdown();
        }
    }
}

