/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.gateway;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xdja.prs.authentication.gateway.UdpCallback;
import com.xdja.prs.authentication.gateway.UdpServer;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GatewayProcess
implements UdpCallback {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> ipToSnMappings = Maps.newHashMap();
    private Map<String, Map<Integer, String>> gatewayPortToSnMappings = Maps.newHashMap();
    private List<String> gatewayIpList = Lists.newArrayList();
    private UdpServer udpServer;

    public void startup(List<String> gatewayIpList, List<Integer> gatewayPortList, int gatewayReceivePort) throws Exception {
        this.gatewayIpList = Lists.newArrayList(gatewayIpList);
        this.logger.debug("gateway ip list : {}", this.gatewayIpList);
        this.udpServer = new UdpServer(gatewayReceivePort, this);
        this.udpServer.startOnlineInfoListenServer();
        this.udpServer.startGetCurrentOnlineInfo(gatewayIpList, gatewayPortList);
    }

    public boolean isGatewayIp(String ip) {
        return this.gatewayIpList.contains(ip);
    }

    public String getSnByIp(String ip) {
        this.logger.debug("\u96a7\u9053\u6a21\u5f0f\uff0c\u5c1d\u8bd5\u901a\u8fc7ip\u83b7\u53d6sn");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5f53\u524d\u6240\u6709\u7684\u96a7\u9053IP\u5217\u8868:{}", this.ipToSnMappings.keySet());
        }
        return this.ipToSnMappings.get(ip);
    }

    public String getSnByPort(String ip, int port) {
        this.logger.debug("\u8f6c\u53d1\u6a21\u5f0f\uff0c\u5c1d\u8bd5\u901a\u8fc7\u7aef\u53e3\u83b7\u53d6sn");
        if (this.gatewayPortToSnMappings.containsKey(ip)) {
            Map<Integer, String> map = this.gatewayPortToSnMappings.get(ip);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("IP:{}\u5bf9\u5e94\u7f51\u5173\u5df2\u4f7f\u7528\u7aef\u53e3\u5217\u8868:{}", (Object)ip, map.keySet());
            }
            return map.get(port);
        }
        this.logger.debug("IP:{}\u4e0d\u5728\u7f51\u5173\u5217\u8868\u4e2d", (Object)ip);
        return null;
    }

    @Override
    public void allOffline(String gatewayIp) {
        Map<Integer, String> portToSn = this.gatewayPortToSnMappings.remove(gatewayIp);
        if (portToSn != null) {
            portToSn.clear();
        }
    }

    @Override
    public void offline(String gatewayIp, String ip, Integer forwardPort, String sn) {
        Assert.hasText((String)sn, (String)"sn empty!");
        if (StringUtils.hasText((String)ip)) {
            this.ipToSnMappings.remove(ip);
        } else if (forwardPort != null && this.gatewayPortToSnMappings.containsKey(gatewayIp)) {
            Map<Integer, String> portToSn = this.gatewayPortToSnMappings.get(ip);
            portToSn.remove(forwardPort);
        }
    }

    @Override
    public void online(String gatewayIp, String ip, Integer forwardPort, String sn) {
        Assert.hasText((String)sn, (String)"sn empty!");
        if (StringUtils.hasText((String)ip)) {
            this.ipToSnMappings.put(ip, sn);
        } else if (forwardPort != null) {
            if (!this.gatewayPortToSnMappings.containsKey(gatewayIp)) {
                this.gatewayPortToSnMappings.put(ip, Maps.newHashMap());
            }
            this.gatewayPortToSnMappings.get(ip).put(forwardPort, sn);
        }
    }

    public void shutdown() throws Exception {
        this.udpServer.shutdown();
    }
}

