/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.gateway;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.xdja.prs.authentication.gateway.UdpCallback;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class UdpServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DatagramSocket datagramSocket;
    private final UdpCallback callback;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public UdpServer(int gatewayReceivePort, UdpCallback callback) throws SocketException {
        this.datagramSocket = new DatagramSocket(gatewayReceivePort);
        this.callback = callback;
    }

    public void startOnlineInfoListenServer() {
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                byte[] recvBuf = new byte[1024];
                DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
                try {
                    while (true) {
                        UdpServer.this.datagramSocket.receive(recvPacket);
                        try {
                            byte[] pack = Arrays.copyOf(recvPacket.getData(), recvPacket.getLength());
                            UdpServer.this.processReceiveUdpPack(recvPacket.getAddress(), recvPacket.getPort(), pack);
                        }
                        catch (Exception e) {
                            UdpServer.this.logger.warn("\u5904\u7406\u6536\u5230\u7684\u6570\u636e\u51fa\u9519\uff01" + e.getMessage(), (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    UdpServer.this.logger.error("\u7f51\u5173\u6570\u636e\u63a5\u6536\u670d\u52a1\u505c\u6b62:" + e.getMessage(), (Throwable)e);
                    return;
                }
            }
        });
    }

    private void processReceiveUdpPack(InetAddress address, int port, byte[] pack) {
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])pack);
        Assert.isTrue((input.readUnsignedByte() == 197 ? 1 : 0) != 0, (String)"pkt_begin != 0xc5");
        int type = input.readUnsignedByte();
        Assert.isTrue((input.readUnsignedByte() == 2 ? 1 : 0) != 0, (String)"version != 0x02");
        int pktLen = input.readUnsignedShort();
        if (type == 145 || type == 144) {
            int markType = input.readUnsignedByte();
            int markLen = input.readUnsignedByte();
            String ip = null;
            Integer forwardPort = null;
            if (markType != 0) {
                if (markType == 1) {
                    ip = this.getVirtualIp(input, markLen);
                } else if (markType == 2) {
                    forwardPort = this.getForwardPort(input, markLen);
                }
            }
            int snLen = input.readUnsignedByte();
            String sn = this.getSnFromPack(input, snLen);
            if (type == 145) {
                this.callback.online(address.getHostAddress(), ip, forwardPort, sn);
            } else if (type == 144) {
                this.callback.offline(address.getHostAddress(), ip, forwardPort, sn);
            }
        } else if (type == 142) {
            this.callback.allOffline(address.getHostAddress());
        }
        int pktEnd = input.readUnsignedByte();
        Assert.isTrue((pktEnd == 92 ? 1 : 0) != 0, (String)"pkt_end = 0x5c");
    }

    private String getSnFromPack(ByteArrayDataInput input, int snLen) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < snLen; ++i) {
            sb.append(Integer.toHexString(input.readUnsignedByte()));
        }
        return sb.toString();
    }

    private Integer getForwardPort(ByteArrayDataInput input, int markLen) {
        return input.readUnsignedShort();
    }

    private String getVirtualIp(ByteArrayDataInput input, int markLen) {
        return input.readUnsignedByte() + "." + input.readUnsignedByte() + "." + input.readUnsignedByte() + "." + input.readUnsignedByte();
    }

    public void startGetCurrentOnlineInfo(List<String> gatewayIpList, List<Integer> gatewayPortList) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeByte(197);
        out.writeByte(143);
        out.writeByte(2);
        out.writeShort(6);
        out.writeByte(92);
        byte[] bytes = out.toByteArray();
        for (int i = 0; i < gatewayIpList.size(); ++i) {
            String gateway = null;
            Integer port = null;
            try {
                gateway = gatewayIpList.get(i);
                port = this.getGatewayPort(gatewayPortList, i);
                DatagramPacket pack = new DatagramPacket(bytes, bytes.length, InetAddress.getByName(gateway), port);
                this.datagramSocket.send(pack);
                continue;
            }
            catch (IOException e) {
                this.logger.warn("\u7ed9{}:{}\u53d1\u9001\u83b7\u53d6\u5f53\u524d\u5728\u7ebf\u901a\u77e5\u4fe1\u606f\u5931\u8d25\uff01" + e.getMessage(), new Object[]{gateway, port, e});
            }
        }
    }

    private Integer getGatewayPort(List<Integer> gatewayPortList, int port) {
        return gatewayPortList.size() == 1 ? gatewayPortList.get(0) : gatewayPortList.get(port);
    }

    public void shutdown() throws Exception {
        this.executorService.shutdownNow();
    }
}

