/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.support.csagent;

import com.google.common.collect.Maps;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.DataManager;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CSDBService {
    private final DataManager dataManager;

    public CSDBService(Configs configs) throws PropertyVetoException {
        Properties props = configs.getProps();
        this.dataManager = new DataManager(props);
    }

    public Map<String, Set<String>> getSn2ResMappingsFromDB() {
        Map<String, Set<String>> app2Group = this.dataManager.getAppResGroupMappings();
        Map<String, Set<String>> app2Res = this.dataManager.getAppResMappings(app2Group);
        Map<String, Set<String>> app2Sn = this.dataManager.getAppSnMappings();
        HashMap sn2Res = Maps.newHashMap();
        for (String app : app2Sn.keySet()) {
            if (!app2Res.containsKey(app)) continue;
            for (String sn : app2Sn.get(app)) {
                sn2Res.put(sn, app2Res.get(app));
            }
        }
        return sn2Res;
    }

    public Map<String, Set<String>> getIp2ResMappingsFromDB() {
        Map<String, Set<String>> ip2Group = this.dataManager.getIp2Group();
        return this.dataManager.getServerIp2ResMappings(ip2Group);
    }

    public void closeDataSource() {
        this.dataManager.closeDataSource();
    }
}

