/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.support.drs;

import com.google.common.collect.Maps;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.DataManager;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DRSDBService {
    private final DataManager dataManager;

    public DRSDBService(Configs configs) throws PropertyVetoException {
        Properties props = configs.getProps();
        this.dataManager = new DataManager(props);
    }

    public Map<String, Set<String>> getIp2TabMappingsFromDB() {
        Map<String, Set<String>> ip2Group = this.dataManager.getIp2Group();
        return this.dataManager.getServerIp2TabMappings(ip2Group);
    }

    public Map<String, Set<String>> getSn2TabMappingsFromDB() {
        Map<String, Set<String>> app2Group = this.dataManager.getAppResGroupMappings();
        Map<String, Set<String>> app2Tab = this.dataManager.getAppTabMappings(app2Group);
        Map<String, Set<String>> app2Sn = this.dataManager.getAppSnMappings();
        HashMap sn2Tab = Maps.newHashMap();
        for (String app : app2Sn.keySet()) {
            if (!app2Tab.containsKey(app)) continue;
            for (String sn : app2Sn.get(app)) {
                sn2Tab.put(sn, app2Tab.get(app));
            }
        }
        return sn2Tab;
    }

    public void closeDataSource() {
        this.dataManager.closeDataSource();
    }
}

