/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.support.drs;

import com.google.common.collect.Lists;
import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.support.drs.DRSPermissions;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public class DRSPermissionContainer
extends AbstractPermissionContainer<DRSPermissions> {
    @Override
    public boolean isValidAppServerIp(String ip, Object ... otherParams) {
        List<Object> locTabNameList = this.getLocTabNames(otherParams);
        Set<String> tabs = ((DRSPermissions)this.getPermissions()).getAppServerIpMappings().get(ip);
        if (tabs != null) {
            return tabs.containsAll(locTabNameList);
        }
        return false;
    }

    @Override
    public boolean isValidSn(String sn, Object ... otherParams) {
        List<Object> locTabNameList = this.getLocTabNames(otherParams);
        Set<String> tabs = ((DRSPermissions)this.getPermissions()).getSnMappings().get(sn);
        if (tabs != null) {
            return tabs.containsAll(locTabNameList);
        }
        return false;
    }

    private List<Object> getLocTabNames(Object[] otherParams) {
        Assert.notEmpty((Object[])otherParams);
        return Lists.newArrayList((Object[])otherParams);
    }
}

