/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.support.drs;

import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.AbstractSyncService;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.Consts;
import com.xdja.prs.authentication.IPermissions;
import com.xdja.prs.authentication.support.drs.DRSDBService;
import com.xdja.prs.authentication.support.drs.DRSPermissions;
import com.xdja.prs.authentication.sync.SyncHttpClient;
import java.beans.PropertyVetoException;

public class DRSSyncService
extends AbstractSyncService {
    private final DRSDBService drsDbService;

    public DRSSyncService(AbstractPermissionContainer permissionContainer, SyncHttpClient syncHttpClient, Configs configs) throws PropertyVetoException {
        super(permissionContainer, syncHttpClient);
        this.drsDbService = new DRSDBService(configs);
    }

    @Override
    protected Consts.AuthenticationType getAuthenticationType() {
        return Consts.AuthenticationType.DRS;
    }

    @Override
    protected IPermissions loadPermissionsFromDB() {
        DRSPermissions drsPermissions = new DRSPermissions();
        drsPermissions.setAppServerIpMappings(this.drsDbService.getIp2TabMappingsFromDB());
        drsPermissions.setSnMappings(this.drsDbService.getSn2TabMappingsFromDB());
        return drsPermissions;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.drsDbService.closeDataSource();
    }
}

