/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.sync;

import com.xdja.prs.authentication.sync.MyRequestHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, MyRequestHandler> requestHandlerMap = new HashMap<String, MyRequestHandler>();
    private ServerBootstrap serverBootstrap;
    private Channel serverChannel;

    public CustomHttpServer registerHandler(String path, MyRequestHandler requestHandler) {
        this.requestHandlerMap.put(path, requestHandler);
        return this;
    }

    public void start(int port) throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("authentication-sync-Boss"));
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("authentication-sync-Worker"));
        this.serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)4096)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
                ch.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                ch.pipeline().addLast(new ChannelHandler[]{new InnerServerHandler()});
            }
        });
        this.serverChannel = this.serverBootstrap.bind(port).sync().channel();
    }

    public void stop() throws InterruptedException {
        this.requestHandlerMap.clear();
        if (this.serverChannel != null) {
            this.serverChannel.close().sync();
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.group().shutdownGracefully();
            this.serverBootstrap.childGroup().shutdownGracefully();
        }
    }

    public void awaitTermination() throws InterruptedException {
        this.serverChannel.closeFuture().sync();
    }

    private class InnerServerHandler
    extends SimpleChannelInboundHandler<FullHttpMessage> {
        private InnerServerHandler() {
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpMessage fullHttpMessage) throws Exception {
            if (fullHttpMessage instanceof FullHttpRequest) {
                FullHttpRequest request = (FullHttpRequest)fullHttpMessage;
                String uri = request.getUri();
                CustomHttpServer.this.logger.debug("receive request uri is {}", (Object)uri);
                for (String one : CustomHttpServer.this.requestHandlerMap.keySet()) {
                    if (!uri.startsWith(one)) continue;
                    ((MyRequestHandler)CustomHttpServer.this.requestHandlerMap.get(one)).handle(request, channelHandlerContext);
                    return;
                }
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                channelHandlerContext.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }
}

