/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.sync;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.xdja.prs.authentication.Consts;
import com.xdja.prs.authentication.IPermissions;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SyncHttpClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RestTemplate rest;
    private final String syncUrl;
    private ObjectMapper jason = new ObjectMapper();

    public SyncHttpClient(String syncUrl, String httpProxyHost, Integer httpProxyPort) {
        this.rest = this.getRestTemplate(httpProxyHost, httpProxyPort);
        this.syncUrl = syncUrl;
    }

    private RestTemplate getRestTemplate(String httpProxyHost, Integer httpProxyPort) {
        if (StringUtils.hasText((String)httpProxyHost)) {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, (int)httpProxyPort));
            requestFactory.setProxy(proxy);
            return new RestTemplate((ClientHttpRequestFactory)requestFactory);
        }
        return new RestTemplate();
    }

    public void sendForSync(Consts.AuthenticationType type, IPermissions permissions) throws JsonProcessingException {
        Assert.notNull((Object)permissions, (String)"permissions");
        HashMap params = Maps.newHashMap();
        if (Consts.AuthenticationType.CSAGENT == type) {
            params.put("type", "CS");
        } else if (Consts.AuthenticationType.DRS == type) {
            params.put("type", "DRS");
        }
        params.put("data", this.jason.writeValueAsString((Object)permissions));
        String rst = (String)this.rest.postForObject(this.syncUrl, (Object)params, String.class, new Object[0]);
        this.logger.debug("result for sync post is [{}]", (Object)rst);
    }
}

