/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.prs.authentication.sync;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.IPermissions;
import com.xdja.prs.authentication.support.csagent.CSPermissions;
import com.xdja.prs.authentication.support.drs.DRSPermissions;
import com.xdja.prs.authentication.sync.CustomHttpServer;
import com.xdja.prs.authentication.sync.MyRequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpServer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private AbstractPermissionContainer<IPermissions> permissionContainer;
    private ObjectMapper jason = new ObjectMapper();
    private CustomHttpServer jettyServer;

    public SyncHttpServer(AbstractPermissionContainer<IPermissions> permissionContainer) {
        this.permissionContainer = permissionContainer;
    }

    public void startup(int httpPort) throws Exception {
        this.logger.info("{} startup....", (Object)this.getClass().getSimpleName());
        this.jettyServer = new CustomHttpServer();
        this.jettyServer.registerHandler("/sync/updatePermission", new MyRequestHandler(){

            @Override
            public void handle(FullHttpRequest request, ChannelHandlerContext ctx) throws Exception {
                SyncHttpServer.this.logger.debug("start process update permission info ");
                HttpMethod method = request.getMethod();
                if (!method.equals((Object)HttpMethod.POST)) {
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
                    ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    String result;
                    try {
                        int length = request.content().readableBytes();
                        byte[] array = new byte[length];
                        request.content().readBytes(array);
                        String content = new String(array, Charsets.UTF_8);
                        SyncHttpServer.this.logger.debug("receive json context : {}", (Object)content);
                        JsonNode jsonNode = SyncHttpServer.this.jason.readTree(content);
                        JsonNode dataNode = jsonNode.get("data");
                        JsonNode typeNode = jsonNode.get("type");
                        String data = dataNode.asText();
                        String type = typeNode.asText();
                        IPermissions permissions = null;
                        if ("DRS".equalsIgnoreCase(type)) {
                            permissions = (IPermissions)SyncHttpServer.this.jason.readValue(data, DRSPermissions.class);
                        } else if ("CS".equalsIgnoreCase(type)) {
                            permissions = (IPermissions)SyncHttpServer.this.jason.readValue(data, CSPermissions.class);
                        }
                        SyncHttpServer.this.updatePermissionToContainer(permissions);
                        result = "success";
                    }
                    catch (Exception e) {
                        result = "failure";
                        SyncHttpServer.this.logger.error("process receive data error!", (Throwable)e);
                    }
                    ByteBuf content = Unpooled.wrappedBuffer((byte[])result.getBytes());
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                    response.headers().set("Content-Type", (Object)"text/plain");
                    response.headers().set("Content-Length", (Object)response.content().readableBytes());
                    ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    SyncHttpServer.this.logger.debug("process over!!!");
                }
            }
        });
        this.jettyServer.start(httpPort);
    }

    public void shutdown() throws Exception {
        this.logger.info("{} shutdown....", (Object)this.getClass().getSimpleName());
        if (this.jettyServer != null) {
            this.jettyServer.stop();
        }
    }

    public void updatePermissionToContainer(IPermissions permissions) {
        this.permissionContainer.updatePermissions(permissions);
    }

    public static void main(String[] args) throws Exception {
        new SyncHttpServer(null).startup(9999);
    }
}

