package com.xdja.prs.authentication;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.ParameterizedType;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.IPermissionContainer<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 14:45
 * note:
 */
public abstract class AbstractPermissionContainer<T extends IPermissions> {
    private T permissions;
    private Logger logger = LoggerFactory.getLogger(getClass());;

    public AbstractPermissionContainer() throws InstantiationException, IllegalAccessException {
        permissions = defaultPermissions();
    }

    protected T getPermissions() {
        return permissions;
    }

    protected T defaultPermissions() throws IllegalAccessException, InstantiationException {
        ParameterizedType parameterizedType = (ParameterizedType) getClass().getGenericSuperclass();
        Class clazz = (Class) parameterizedType.getActualTypeArguments()[0];
        return (T) clazz.newInstance();
    }

    /**
     * 方法描述：更新鉴权信息
     *
     * @param permissions
     * @author: 黄地
     * @date: 2015-08-24 16:23:56
     */
    public final void updatePermissions(T permissions) {
        if (this.permissions.getClass().isInstance(permissions)) {
            T old = this.permissions;
            this.permissions = permissions;
            if (old != null) {
                old.destory();
            }
        } else {
            logger.warn("无效的数据类型");
        }
    }

    /**
     * @param ip
     * @param otherParams
     * @return
     * @description: 验证IP权限
     * @2015年9月9日 下午3:48:45
     * @author: RPP
     */
    public abstract boolean isValidAppServerIp(String ip, Object... otherParams);

    /**
     * @param sn
     * @param otherParams
     * @return
     * @description: 验证SN权限
     * @2015年9月9日 下午3:49:21
     * @author: RPP
     */
    public abstract boolean isValidSn(String sn, Object... otherParams);
}
