package com.xdja.prs.authentication;

import com.xdja.prs.authentication.sync.SyncHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.*;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.ISyncService<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 14:47
 * note:
 */
 public abstract class AbstractSyncService {
    private Logger logger = LoggerFactory.getLogger(getClass());
    private AbstractPermissionContainer permissionContainer;
    private SyncHttpClient syncHttpClient;
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
    private final ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
    private ScheduledFuture<?> scheduledFuture;

    public AbstractSyncService(AbstractPermissionContainer permissionContainer, SyncHttpClient syncHttpClient) {
        this.permissionContainer = permissionContainer;
        this.syncHttpClient = syncHttpClient;
    }

    private void sync() {
        logger.info("开始同步鉴权信息......");
        try {
            final IPermissions permissions = loadPermissionsFromDB();
            permissionContainer.updatePermissions(permissions);
            singleThreadExecutor.submit(new Runnable() {
                @Override
                public void run() {
                    try {
                        syncHttpClient.sendForSync(getAuthenticationType(),permissions);
                    } catch (Exception e) {
                        logger.error("将配置信息发送给远程出错!", e);
                    }
                }
            });
        } catch (Exception e) {
            logger.error("定时更新配置出错!", e);
        } finally {
            logger.info("结束同步鉴权信息......");
        }
    }

    protected abstract Consts.AuthenticationType getAuthenticationType();

    protected abstract IPermissions loadPermissionsFromDB();

    public void shutdown() {
        logger.info("SyncService shutdown....");
        singleThreadExecutor.shutdownNow();
        scheduledExecutorService.shutdownNow();
    }

    public void startup(int syncPeriod) {
        if (scheduledFuture != null) {
            throw new IllegalStateException("SyncService has already started！！！");
        }
        logger.info("SyncService startup , sync period is {} ", syncPeriod);
        scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(new Runnable() {
            @Override
            public void run() {
                sync();
            }
        }, 0, syncPeriod, TimeUnit.MILLISECONDS);
    }
}
