package com.xdja.prs.authentication;

import com.xdja.prs.authentication.gateway.GatewayProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.IAuthenticate<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 15:29
 * note:
 */
class Authenticate implements IAuthenticate {
    private Logger logger = LoggerFactory.getLogger(getClass());
    private GatewayProcess gatewayProcess;
    private AbstractPermissionContainer permissionContainer;

    Authenticate(GatewayProcess gatewayProcess, AbstractPermissionContainer permissionContainer) {
        this.gatewayProcess = gatewayProcess;
        this.permissionContainer = permissionContainer;
    }

    @Override
    public boolean authenticate(Map<String, Object> context, String ip, int port, Object... otherParams) {
        String identity = "";
        String identityType = "";
        String sn = null;
        boolean rst = false;
        logger.debug("begin authenticate for ip:{},port:{}", ip, port);
        if (gatewayProcess.isGatewayIp(ip)) {   //网关ip
            logger.debug("check gateway ip : true");
            sn = gatewayProcess.getSnByPort(ip, port);
        } else {    //非网关ip
            logger.debug("check gateway ip : false");
            if (permissionContainer.isValidAppServerIp(ip, otherParams)) {
                //有效的应用服务器ip，鉴权通过
                logger.debug("check appServer ip : true");
                identity = ip;
                identityType = IDENTITY_TYPE_IP;
                rst = true;
            } else {
                logger.debug("check appServer ip : false");
                sn = gatewayProcess.getSnByIp(ip);
            }
        }
        logger.debug("final sn is : {}", sn);
        if (StringUtils.hasText(sn)) {
            identity = sn;
            identityType = IDENTITY_TYPE_SN;
            rst = permissionContainer.isValidSn(sn, otherParams);
        }
        if (context != null) {
            context.put(KEY_IDENTITY, identity);
            context.put(KEY_IDENTITY_TYPE, identityType);
        }
        return rst;
    }
}
