package com.xdja.prs.authentication;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Properties;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.Configs<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/25 09:26
 * note:
 */
public class Configs {
    private final Properties props;

    public static final String AUTH_AUTH_TYPE = "auth.authType";
    public static final String AUTH_NET_LOCATION = "auth.netLocation";
    public static final String AUTH_SYNC_PERIOD = "auth.syncPeriod";
    public static final String AUTH_GATEWAY_IP = "auth.gatewayIp";
    public static final String AUTH_GATEWAY_PORT = "auth.gatewayPort";
    public static final String AUTH_HTTP_PROXY_PORT = "auth.httpProxyPort";
    public static final String AUTH_HTTP_PROXY_IP = "auth.httpProxyIp";
    public static final String AUTH_SYNC_URL = "auth.syncUrl";
    public static final String AUTH_HTTP_PORT = "auth.httpPort";
    public static final String AUTH_GATEWAY_RECEIVE_PORT = "auth.gatewayReceivePort";


    public Configs(Properties props) {
        this.props = props;
    }

    public Properties getProps() {
        return props;
    }

    /**
     * 方法描述：获取程序要使用的鉴权类型
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 17:22:12
     */
    public Consts.AuthenticationType getAuthenticationType() {
        String property = props.getProperty(AUTH_AUTH_TYPE);
        Assert.hasText(property, AUTH_AUTH_TYPE);
        Integer type = Ints.tryParse(property);
        if (type != null) {
            return Consts.AuthenticationType.indexOf(type.byteValue());
        } else {
            return Consts.AuthenticationType.valueOf(property.trim());
        }
    }

    /**
     * 方法描述：获取程序部署的网络位置
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 17:22:15
     */
    public Consts.NetLocation getNetLocation() {
        String property = props.getProperty(AUTH_NET_LOCATION);
        Assert.hasText(property, AUTH_NET_LOCATION);
        Integer type = Ints.tryParse(property);
        if (type != null) {
            return Consts.NetLocation.indexOf(type.byteValue());
        } else {
            return Consts.NetLocation.valueOf(property.trim());
        }
    }

    /**
     * 方法描述：获取定时同步的周期，单位毫秒
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 17:22:19
     */
    public int getSyncPeriod() {
        String property = props.getProperty(AUTH_SYNC_PERIOD);
        Assert.hasText(property, AUTH_SYNC_PERIOD);
        return Integer.parseInt(property);
    }

    /**
     * 方法描述：用于接收网关上下线信息的端口
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 19:02:36
     */
    public int getGatewayReceivePort() {
        String property = props.getProperty(AUTH_GATEWAY_RECEIVE_PORT);
        Assert.hasText(property, AUTH_GATEWAY_RECEIVE_PORT);
        return Integer.parseInt(property);
    }

    /**
     * 方法描述：用于提供http服务的端口，用于接收同步过来的鉴权信息
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 19:02:33
     */
    public int getHttpPort() {
        String property = props.getProperty(AUTH_HTTP_PORT);
        Assert.hasText(property, AUTH_HTTP_PORT);
        return Integer.parseInt(property);
    }

    /**
     * 方法描述：获取网关IP列表
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 17:19:09
     */
    public List<String> getGatewayIpList() {
        List<String> rst = Lists.newArrayList();
        String property = props.getProperty(AUTH_GATEWAY_IP);
        if (StringUtils.hasLength(property)) {
            String[] split = property.trim().split(",");
            for (String tmp : split) {
                if (StringUtils.hasLength(tmp)) {
                    rst.add(tmp.trim());
                }
            }
        }
        return rst;
    }

    /**
     * 方法描述：获取网关IP列表
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 17:19:09
     */
    public List<Integer> getGatewayPortList() {
        List<Integer> rst = Lists.newArrayList();
        String property = props.getProperty(AUTH_GATEWAY_PORT);
        if (StringUtils.hasLength(property)) {
            String[] split = property.trim().split(",");
            for (String tmp : split) {
                if (StringUtils.hasLength(tmp)) {
                    rst.add(Integer.parseInt(tmp.trim()));
                }
            }
        }
        return rst;
    }

    /**
     * 方法描述：同步服务发送数据的目的地址
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 19:02:18
     */
    public String getSyncUrl() {
        String property = props.getProperty(AUTH_SYNC_URL);
        Assert.hasText(property, AUTH_SYNC_URL);
        return property;
    }

    /**
     * 方法描述：同步服务发送数据时要使用的http proxy的ip地址
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 19:02:23
     */
    public String getHttpProxyIp() {
        String property = props.getProperty(AUTH_HTTP_PROXY_IP);
//        Assert.hasText(property, AUTH_HTTP_PROXY_IP);
        return property;
    }

    /**
     * 方法描述：同步服务发送数据时要使用的http proxy的端口号
     *
     * @return
     * @author: 黄地
     * @date: 2015-08-25 19:02:27
     */
    public Integer getHttpProxyPort() {
        String property = props.getProperty(AUTH_HTTP_PROXY_PORT);
        Assert.hasText(property, AUTH_HTTP_PROXY_PORT);
        return Integer.parseInt(property);
    }
}
