package com.xdja.prs.authentication;

import com.xdja.prs.authentication.gateway.GatewayProcess;
import com.xdja.prs.authentication.support.csagent.CSPermissionContainer;
import com.xdja.prs.authentication.support.csagent.CSSyncService;
import com.xdja.prs.authentication.support.drs.DRSPermissionContainer;
import com.xdja.prs.authentication.support.drs.DRSSyncService;
import com.xdja.prs.authentication.sync.SyncHttpClient;
import com.xdja.prs.authentication.sync.SyncHttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.PrsAuthentication<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/25 09:44
 * note:
 */
public class PrsAuthentication {
    private Logger logger = LoggerFactory.getLogger(getClass());
    private SyncHttpServer syncHttpServer;
    private final GatewayProcess gatewayProcess;
    private final IAuthenticate authenticate;
    private AbstractSyncService syncService;

    public PrsAuthentication(Configs configs) throws Exception {
        Consts.AuthenticationType type = configs.getAuthenticationType();
        AbstractPermissionContainer permissionContainer = null;
        gatewayProcess = new GatewayProcess();

        logger.info("Current Authentication Type is {}", type);
        if (Consts.AuthenticationType.CSAGENT == type) {
            permissionContainer = new CSPermissionContainer();
        } else if (Consts.AuthenticationType.DRS == type) {
            permissionContainer = new DRSPermissionContainer();
        } else {
            throw new IllegalArgumentException("Unknow AuthenticationType : " + type);
        }

        Consts.NetLocation location = configs.getNetLocation();
        logger.info("Current Net Location is {}", location);
        if (Consts.NetLocation.SwitchIn == location) {
            //  启动HttpServer
            syncHttpServer = new SyncHttpServer(permissionContainer);
            syncHttpServer.startup(configs.getHttpPort());
            List<String> gatewayIpList = configs.getGatewayIpList();
            List<Integer> gatewayPortList = configs.getGatewayPortList();
            if (gatewayIpList.size() != gatewayPortList.size() && gatewayPortList.size() != 1) {
                throw new IllegalArgumentException("网关ip数量与网关端口数量不一致！");
            }
            gatewayProcess.startup(gatewayIpList, gatewayPortList, configs.getGatewayReceivePort());
        } else if (Consts.NetLocation.Intranet == location) {
            //  启动配置定时同步模块
            SyncHttpClient httpClient = new SyncHttpClient(configs.getSyncUrl(), configs.getHttpProxyIp(), configs.getHttpProxyPort());
            if (Consts.AuthenticationType.CSAGENT == type) {
                syncService = new CSSyncService(permissionContainer, httpClient,configs);
            } else if (Consts.AuthenticationType.DRS == type) {
                syncService = new DRSSyncService(permissionContainer, httpClient,configs);
            }
            syncService.startup(configs.getSyncPeriod());
        }

        authenticate = new Authenticate(gatewayProcess, permissionContainer);
    }

    public IAuthenticate getAuthenticate() {
        return authenticate;
    }

    public void stop() throws Exception {
        if (gatewayProcess != null) {
            gatewayProcess.shutdown();
        }
        if (syncHttpServer != null) {
            syncHttpServer.shutdown();
        }
        if (syncService != null) {
            syncService.shutdown();
        }
    }
}
