package com.xdja.prs.authentication.support.csagent;

import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.DataManager;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.support.csagent.CSDBService<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 15:23
 * note:
 */
public class CSDBService {
	
	private final DataManager dataManager;

    public CSDBService(Configs configs) throws PropertyVetoException {
        Properties props = configs.getProps();
        this.dataManager = new DataManager(props);
    }
    
    public Map<String, Set<String>> getSn2ResMappingsFromDB() {
    	
    	//应用-资源 关系
    	Map<String, Set<String>> app2Group = dataManager.getAppResGroupMappings();
    	Map<String, Set<String>> app2Res = dataManager.getAppResMappings(app2Group);
    	
    	//SN-应用 关系
    	Map<String, Set<String>> app2Sn = dataManager.getAppSnMappings();
    	
    	//SN-资源 关系
    	Map<String, Set<String>> sn2Res = Maps.newHashMap();
    	for(String app : app2Sn.keySet()) {
    		if(app2Res.containsKey(app)) {
    			for(String sn : app2Sn.get(app)) {
    				if(!sn2Res.containsKey(sn)) {
    					sn2Res.put(sn, Sets.<String>newHashSet());
    				}
    				sn2Res.get(sn).addAll(app2Res.get(app));
    			}
    		}
    	}
    	
    	return sn2Res;
    }
    
    /**
     * @description: 查询 应用服务器IP-资源 关系
     * @return 应用服务器IP-资源 关系
     * @2015年9月9日 下午3:23:45
     * @author: RPP
     */
    public Map<String, Set<String>> getIp2ResMappingsFromDB() {
    	
    	Map<String, Set<String>> ip2Group = dataManager.getIp2Group();
    	return dataManager.getServerIp2ResMappings(ip2Group);
    }

    /**
     * @description: 关闭多有数据库连接(MDP、PAMS、PRS)
     * @2015年9月9日 下午3:27:17
     * @author: RPP
     */
    public void closeDataSource() {
    	this.dataManager.closeDataSource();
    }
}
