package com.xdja.prs.authentication.support.csagent;

import com.xdja.prs.authentication.AbstractPermissionContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

import java.util.Set;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.support.csagent.CSPermissionContainer<br/>
 * Description：<br/>
 *
 * @author:
 * @date: note:
 */
public class CSPermissionContainer extends AbstractPermissionContainer<CSPermissions> {
    private Logger logger = LoggerFactory.getLogger(getClass());

    public CSPermissionContainer() throws InstantiationException, IllegalAccessException {
        super();
    }


    @Override
    public boolean isValidAppServerIp(String ip, Object... otherParams) {
        boolean result = false;
        String resourceId = getResourceId(otherParams);
        logger.debug("开始验证appServerIp,请求IP为{},资源ID为{}", ip, resourceId);
        if (logger.isDebugEnabled()) {
            logger.debug("可用的appServerIp列表:{}", getPermissions().getAppServerIpMappings().keySet().toString());
        }
        if (getPermissions().getAppServerIpMappings().containsKey(ip)) {
            Set<String> ids = getPermissions().getAppServerIpMappings().get(ip);
            if (logger.isDebugEnabled()) {
                logger.debug("IP:{}对应的资源列表:{}", ip, ids.toString());
            }
            if (ids != null) {
                result = ids.contains(resourceId);
            }
        } else {
            logger.debug("不存在IP:{}对应的资源信息", ip);
        }
        return result;
    }

    private String getResourceId(Object[] otherParams) {
        Assert.notEmpty(otherParams);
        return otherParams[0].toString();
    }

    @Override
    public boolean isValidSn(String sn, Object... otherParams) {
        String resourceId = getResourceId(otherParams);
        Set<String> ids = getPermissions().getSnMappings().get(sn);
        if (ids != null) {
            return ids.contains(resourceId);
        }
        return false;
    }
}
