package com.xdja.prs.authentication.support.csagent;

import com.google.common.collect.Maps;
import com.xdja.prs.authentication.IPermissions;

import java.util.Map;
import java.util.Set;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.support.csagent.CSPermissions<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 15:23
 * note:
 */
public class CSPermissions implements IPermissions {
    private Map<String, Set<String>> appServerIpMappings= Maps.newHashMap();
    private Map<String, Set<String>> snMappings=Maps.newHashMap();

    public CSPermissions() {
    }

    public CSPermissions(Map<String, Set<String>> appServerIpMappings, Map<String, Set<String>> snMappings) {
        this.appServerIpMappings.clear();
        this.appServerIpMappings.putAll(appServerIpMappings);
        this.snMappings.clear();
        this.snMappings.putAll(snMappings);
    }

    public Map<String, Set<String>> getAppServerIpMappings() {
        return appServerIpMappings;
    }

    public void setAppServerIpMappings(Map<String, Set<String>> appServerIpMappings) {
        this.appServerIpMappings = appServerIpMappings;
    }

    public Map<String, Set<String>> getSnMappings() {
        return snMappings;
    }

    public void setSnMappings(Map<String, Set<String>> snMappings) {
        this.snMappings = snMappings;
    }

    @Override
    public void destory() {
        for (Set one : appServerIpMappings.values()) {
            one.clear();
        }
        appServerIpMappings.clear();


        for (Set one : snMappings.values()) {
            one.clear();
        }
        snMappings.clear();
    }
}
