package com.xdja.prs.authentication.support.csagent;

import com.xdja.prs.authentication.*;
import com.xdja.prs.authentication.sync.SyncHttpClient;

import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.support.csagent.CSSyncService<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 15:23
 * note:
 */
public class CSSyncService extends AbstractSyncService {
    public static boolean DEBUG_FLAG = false;
    private final CSDBService csdbService;

    public CSSyncService(AbstractPermissionContainer permissionContainer, SyncHttpClient syncHttpClient, Configs configs) throws PropertyVetoException {
        super(permissionContainer, syncHttpClient);
        csdbService = new CSDBService(configs);
    }

    @Override
    protected Consts.AuthenticationType getAuthenticationType() {
        return Consts.AuthenticationType.CSAGENT;
    }

    @Override
    protected IPermissions loadPermissionsFromDB() {
        if (DEBUG_FLAG) {
            HashMap<String, Set<String>> appServerIpMappings = new HashMap<String, Set<String>>();
            HashSet<String> value = new HashSet<String>();
            value.add("hello");
            appServerIpMappings.put("aaaa", value);
            HashMap<String, Set<String>> snMappings = new HashMap<String, Set<String>>();
            HashSet<String> value1 = new HashSet<String>();
            value1.add("world");
            snMappings.put("bbb", value1);
            return new CSPermissions(appServerIpMappings, snMappings);
        } else {
            CSPermissions csPermissions = new CSPermissions();
            csPermissions.setAppServerIpMappings(csdbService.getIp2ResMappingsFromDB());
            csPermissions.setSnMappings(csdbService.getSn2ResMappingsFromDB());
            return csPermissions;
        }
    }

    public void shutdown() {
        super.shutdown();
        csdbService.closeDataSource();
    }
}
