package com.xdja.prs.authentication.support.drs;

import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.DataManager;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.support.csagent.CSDBService<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 15:23
 * note:
 */
public class DRSDBService {
	
	private final DataManager dataManager;

    public DRSDBService(Configs configs) throws PropertyVetoException {
    	
    	Properties props = configs.getProps();
    	this.dataManager = new DataManager(props);
    }
    
    /**
     * @description: 查询 应用服务器IP-本地表 关系
     * @return 应用服务器IP-本地表 关系
     * @2015年9月9日 下午2:54:00
     * @author: RPP
     */
    public Map<String, Set<String>> getIp2TabMappingsFromDB() {
    	
    	Map<String, Set<String>> ip2Group = dataManager.getIp2Group();
    	return dataManager.getServerIp2TabMappings(ip2Group);
    }

    /**
     * @description: 查询 SN-本地表 关系
     * @return SN-本地表 关系
     * @2015年9月9日 下午2:54:53
     * @author: RPP
     */
    public Map<String, Set<String>> getSn2TabMappingsFromDB() {
    	
    	//应用-本地表 关系
    	Map<String, Set<String>> app2Group = dataManager.getAppResGroupMappings();
    	Map<String, Set<String>> app2Tab = dataManager.getAppTabMappings(app2Group);
    	
    	//SN-应用 关系
    	Map<String, Set<String>> app2Sn = dataManager.getAppSnMappings();
    	
    	Map<String, Set<String>> sn2Tab = Maps.newHashMap();
    	Set<String> tabs = Sets.newHashSet();
    	for(String app : app2Sn.keySet()) {
    		if(app2Tab.containsKey(app)) {
    			for(String sn : app2Sn.get(app)) {
    				if(!sn2Tab.containsKey(sn)) {
    					sn2Tab.put(sn, Sets.<String>newHashSet());
    				}
    				sn2Tab.get(sn).addAll(app2Tab.get(app));
    			}
    		}
    	}
    	
    	return sn2Tab;
    }
    
    /**
     * @description: 关闭多有数据库连接(MDP、PAMS、PRS)
     * @2015年9月9日 下午3:13:04
     * @author: RPP
     */
    public void closeDataSource() {
    	this.dataManager.closeDataSource();
	}
}
