package com.xdja.prs.authentication.support.drs;

import java.util.List;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

import com.google.common.collect.Lists;
import com.xdja.prs.authentication.AbstractPermissionContainer;

/**
 * @description: DRS鉴权容器,多表校验时任何一个表名校验不通过,作为校验不通过处理
 * @2015年9月2日 下午5:13:26
 * @author: RPP
 * @note:
 */
public class DRSPermissionContainer extends AbstractPermissionContainer<DRSPermissions> {
	
	private Logger logger = LoggerFactory.getLogger(getClass());
	
    public DRSPermissionContainer() throws InstantiationException, IllegalAccessException {
    }
    
    @Override
    public boolean isValidAppServerIp(String ip, Object... otherParams) {
        
    	logger.debug("请求方IP: {}", ip);
    	
    	List<Object> locTabNameList = getLocTabNames(otherParams);
    	logger.debug("请求访问表: {}", locTabNameList.toString());
    	
    	Set<String> tabs = getPermissions().getAppServerIpMappings().get(ip);
    	
    	if (tabs != null) {
    		logger.debug("ip:{}有权限的本地表有: {}", ip, tabs.toString());
    		return tabs.containsAll(locTabNameList);
    	}
    	
    	logger.debug("ip{}无任何表权限", ip);
        return false;
    }

    @Override
    public boolean isValidSn(String sn, Object... otherParams) {
    	
    	logger.debug("请求方SN: {}", sn);
    	
    	List<Object> locTabNameList = getLocTabNames(otherParams);
    	logger.debug("请求访问表: {}", locTabNameList.toString());
    	Set<String> tabs = getPermissions().getSnMappings().get(sn);
    	
    	if(tabs != null) {
    		logger.debug("sn:{}有权限的本地表有: {}", sn, tabs.toString());
    		return tabs.containsAll(locTabNameList);
    	}
    	
    	logger.debug("sn:{}无任何表权限", sn);
        return false;
    }
    
    private List<Object> getLocTabNames(Object[] otherParams) {
        Assert.notEmpty(otherParams);
        return Lists.newArrayList(otherParams);
    }
}
