package com.xdja.prs.authentication.support.drs;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.Maps;
import com.xdja.prs.authentication.IPermissions;

/**
 * @description: DRS鉴权Permissions
 * @2015年9月6日 下午2:26:59
 * @author: RPP
 * @note:
 */
public class DRSPermissions implements IPermissions{
	
	/**
	 * 应用服务器-本地表 关系
	 */
	private Map<String, Set<String>> appServerIpMappings = Maps.newHashMap();
	
	/**
	 * SN-本地表 关系
	 */
    private Map<String, Set<String>> snMappings = Maps.newHashMap();

    public DRSPermissions() {
    }

    public DRSPermissions(Map<String, Set<String>> appServerIpMappings, Map<String, Set<String>> snMappings) {
        this.appServerIpMappings.clear();
        this.appServerIpMappings.putAll(appServerIpMappings);
        this.snMappings.clear();
        this.snMappings.putAll(snMappings);
    }

    public Map<String, Set<String>> getAppServerIpMappings() {
        return appServerIpMappings;
    }

    public void setAppServerIpMappings(Map<String, Set<String>> appServerIpMappings) {
        this.appServerIpMappings = appServerIpMappings;
    }

    public Map<String, Set<String>> getSnMappings() {
        return snMappings;
    }

    public void setSnMappings(Map<String, Set<String>> snMappings) {
        this.snMappings = snMappings;
    }

    @Override
    public void destory() {
        for (Set one : appServerIpMappings.values()) {
            one.clear();
        }
        appServerIpMappings.clear();


        for (Set one : snMappings.values()) {
            one.clear();
        }
        snMappings.clear();
    }
}
