package com.xdja.prs.authentication.support.drs;

import java.beans.PropertyVetoException;

import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.AbstractSyncService;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.Consts;
import com.xdja.prs.authentication.IPermissions;
import com.xdja.prs.authentication.sync.SyncHttpClient;

/**
 * @description: DRS同步Server
 * @2015年9月6日 下午2:57:23
 * @author: RPP
 * @note:
 */
public class DRSSyncService extends AbstractSyncService{
	
	private final DRSDBService drsDbService;
	
    public DRSSyncService(AbstractPermissionContainer permissionContainer, SyncHttpClient syncHttpClient, Configs configs) throws PropertyVetoException {
        super(permissionContainer, syncHttpClient);
        drsDbService=new DRSDBService(configs);
    }

    @Override
    protected Consts.AuthenticationType getAuthenticationType() {
        return Consts.AuthenticationType.DRS;
    }

    @Override
    protected IPermissions loadPermissionsFromDB() {
        
    	DRSPermissions drsPermissions = new DRSPermissions();
    	drsPermissions.setAppServerIpMappings(drsDbService.getIp2TabMappingsFromDB());
    	drsPermissions.setSnMappings(drsDbService.getSn2TabMappingsFromDB());
        return drsPermissions;
        
    }
    
    public void shutdown() {
        super.shutdown();
        drsDbService.closeDataSource();
    }
}
