package com.xdja.prs.authentication.sync;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.xdja.prs.authentication.Consts;
import com.xdja.prs.authentication.IPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Map;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.sync.SyncHttpClient<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 14:40
 * note:
 */
public class SyncHttpClient {
    private Logger logger = LoggerFactory.getLogger(getClass());
    private final RestTemplate rest;
    private final String syncUrl;
    private ObjectMapper jason = new ObjectMapper();

    public SyncHttpClient(String syncUrl, String httpProxyHost, Integer httpProxyPort) {
        rest = getRestTemplate(httpProxyHost, httpProxyPort);
        this.syncUrl = syncUrl;
    }

    private RestTemplate getRestTemplate(String httpProxyHost, Integer httpProxyPort) {
        if (StringUtils.hasText(httpProxyHost)) {
            SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();

            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, httpProxyPort));
            requestFactory.setProxy(proxy);

            return new RestTemplate(requestFactory);
        } else {
            return new RestTemplate();
        }
    }

    /**
     * @param type
     * @param permissions
     */
    public void sendForSync(Consts.AuthenticationType type, IPermissions permissions) throws JsonProcessingException {
        Assert.notNull(permissions,"permissions");
        Map<String, String> params = Maps.newHashMap();
        if (Consts.AuthenticationType.CSAGENT == type) {
            params.put("type", "CS");
        } else if (Consts.AuthenticationType.DRS == type) {
            params.put("type", "DRS");
        }
        params.put("data", jason.writeValueAsString(permissions));

        String rst = rest.postForObject(this.syncUrl, params, String.class);
        logger.debug("result for sync post is [{}]",rst);
    }
}
