package com.xdja.prs.authentication.sync;

//import com.fasterxml.jackson.databind.JsonNode;
//import com.fasterxml.jackson.databind.ObjectMapper;
//import com.google.common.base.Charsets;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.xdja.prs.authentication.AbstractPermissionContainer;
import com.xdja.prs.authentication.IPermissions;
import com.xdja.prs.authentication.support.csagent.CSPermissions;
import com.xdja.prs.authentication.support.drs.DRSPermissions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static io.netty.handler.codec.http.HttpHeaders.Names.CONTENT_LENGTH;
import static io.netty.handler.codec.http.HttpHeaders.Names.CONTENT_TYPE;

//import com.xdja.prs.authentication.support.csagent.CSPermissions;
//import com.xdja.prs.authentication.support.drs.DRSPermissions;
//
//import org.apache.http.*;
//import org.apache.http.entity.ContentType;
//import org.apache.http.entity.StringEntity;
//import org.apache.http.protocol.HttpContext;
//import org.apache.http.protocol.HttpRequestHandler;
//import org.apache.http.util.EntityUtils;
//import java.util.Locale;

/**
 * Project Name：prs-authentication<br/>
 * ClassName： com.xdja.prs.authentication.sync.SyncHttpServer<br/>
 * Description：<br/>
 *
 * @author: 黄地
 * @date: 2015/08/24 14:40
 * note:
 */
public class SyncHttpServer {
    private Logger logger = LoggerFactory.getLogger(getClass());
    private AbstractPermissionContainer<IPermissions> permissionContainer;
    private ObjectMapper jason = new ObjectMapper();
    private CustomHttpServer jettyServer;

    public SyncHttpServer(AbstractPermissionContainer<IPermissions> permissionContainer) {
        this.permissionContainer = permissionContainer;
    }

    /**
     * 方法描述：启动
     *
     * @param httpPort
     * @throws Exception
     * @author: 黄地
     * @date: 2015-08-24 14:50:42
     */
    public void startup(int httpPort) throws Exception {
        logger.info("{} startup....", getClass().getSimpleName());
        jettyServer = new CustomHttpServer();
        jettyServer.registerHandler("/sync/updatePermission", new MyRequestHandler() {
            @Override
            public void handle(FullHttpRequest request, ChannelHandlerContext ctx) throws Exception {
                logger.debug("start process update permission info ");
                HttpMethod method = request.getMethod();
                if (!method.equals(HttpMethod.POST)) {
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
                    ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
                } else {
                    String result;
                    try {
                        int length = request.content().readableBytes();
                        byte[] array = new byte[length];
                        request.content().readBytes(array);
                        String content = new String(array, Charsets.UTF_8);
                        logger.debug("receive json context : {}", content);
                        JsonNode jsonNode = jason.readTree(content);
                        JsonNode dataNode = jsonNode.get("data");
                        JsonNode typeNode = jsonNode.get("type");
                        String data = dataNode.asText();
                        String type = typeNode.asText();
                        IPermissions permissions = null;
                        if ("DRS".equalsIgnoreCase(type)) {
                            permissions = jason.readValue(data, DRSPermissions.class);
                        } else if ("CS".equalsIgnoreCase(type)) {
                            permissions = jason.readValue(data, CSPermissions.class);
                        }
                        updatePermissionToContainer(permissions);
                        result = "success";
                    } catch (Exception e) {
                        result = "failure";
                        logger.error("process receive data error!", e);
                    }
                    ByteBuf content = Unpooled.wrappedBuffer(result.getBytes());
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
                    response.headers().set(CONTENT_TYPE, "text/plain");
                    response.headers().set(CONTENT_LENGTH, response.content().readableBytes());
                    ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
                    logger.debug("process over!!!");
                }

            }
        });

        jettyServer.start(httpPort);
    }

    /**
     * 方法描述：停止http服务
     *
     * @throws Exception
     * @author: 黄地
     * @date: 2015-08-24 14:52:15
     */
    public void shutdown() throws Exception {
        logger.info("{} shutdown....", getClass().getSimpleName());
        if (jettyServer != null) {
            jettyServer.stop();
        }
    }

    public void updatePermissionToContainer(IPermissions permissions) {
        permissionContainer.updatePermissions(permissions);
    }

    public static void main(String[] args) throws Exception {
        new SyncHttpServer(null).startup(9999);
    }
}
