/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushmanagerclient.start;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pushmanager.stub.PushManagerStub;
import com.xdja.pushmanager.thrift.datatype.ResInt;
import com.xdja.pushmanager.thrift.datatype.ResListStr;
import com.xdja.pushmanager.thrift.datatype.ResLong;
import com.xdja.pushmanager.thrift.datatype.ResMapStrStr;
import com.xdja.pushmanager.thrift.datatype.ResStr;
import com.xdja.pushmanagerclient.common.DefaultValues;
import com.xdja.pushmanagerclient.common.ReturnValues;
import com.xdja.pushmanagerclient.common.Utils;
import com.xdja.pushmanagerclient.start.Message;
import com.xdja.pushmanagerclient.start.Result;
import com.xdja.rpcstubpool.RpcClientInfo;
import com.xdja.rpcstubpool.RpcStubPool;
import com.xdja.rpcstubpool.RpcStubPoolConfig;
import com.xdja.rpcstubpool.RpcStubPushManagerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMClient {
    private static Logger logger = LoggerFactory.getLogger(PMClient.class);
    private RpcStubPushManagerFactory rpcfactory = null;
    public RpcStubPool<RpcClientInfo<PushManagerStub.Client>> rpcstubpool = null;
    private RpcStubPoolConfig config = new RpcStubPoolConfig();
    private int timeout = 2000;
    private int serverMode = 3;
    private String sHost = "";
    private int sPort = -1;
    public static Map<Integer, String> err2reason = new HashMap<Integer, String>();

    public PMClient(String serverHost, int serverPort) {
        this.sHost = serverHost;
        this.sPort = serverPort;
        this.config.setMaxActive(100);
        this.config.setMaxIdle(100);
        this.config.setMaxWait(3000L);
        this.config.setTestWhileIdle(false);
        this.config.setMinEvictableIdleTimeMillis(3600000L);
        this.config.setTestOnBorrow(true);
        this.config.setTestOnReturn(false);
    }

    public PMClient(String serverHost, int serverPort, int serverMode, RpcStubPoolConfig config, int timeout) {
        this.timeout = timeout;
        this.config = config;
        this.serverMode = serverMode;
        this.sHost = serverHost;
        this.sPort = serverPort;
    }

    public boolean init(long reqId) {
        String logFlag = "PMClient.init";
        logger.info("[lid:{}][{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{reqId, logFlag, this.sHost, this.sPort, this.serverMode});
        err2reason.put(ReturnValues.SUCCESS, "Success");
        err2reason.put(ReturnValues.SUC_PARTIAL, "Paritial success");
        err2reason.put(ReturnValues.SERVER_UNWORKING, " Server unworking");
        err2reason.put(ReturnValues.NO_CONTENT, "no content");
        err2reason.put(ReturnValues.PARAMETER_ERROR, "Parameter error");
        err2reason.put(ReturnValues.INNER_ERROR, "Inner error");
        err2reason.put(ReturnValues.REQUEST_TOOFAST, "Network busy");
        err2reason.put(ReturnValues.USERNUM_OVERFLOW, "Dst user number exceed limit");
        err2reason.put(ReturnValues.MSG_OVERLEANGTH, "Msg overlength");
        this.rpcfactory = new RpcStubPushManagerFactory(this.sHost, this.sPort, this.serverMode, this.timeout);
        this.rpcstubpool = new RpcStubPool();
        if (!this.rpcstubpool.init(reqId, this.config, (PoolableObjectFactory<RpcClientInfo<PushManagerStub.Client>>)this.rpcfactory)) {
            logger.warn("[lid:{}]  rpcpool init failed!", (Object)reqId);
            return false;
        }
        return true;
    }

    private RpcClientInfo<PushManagerStub.Client> getServiceClient(long reqId) {
        String logFlag = "PMClient.getServiceClient";
        RpcClientInfo<PushManagerStub.Client> rpcconnect = null;
        try {
            rpcconnect = this.rpcstubpool.getResource(reqId);
            return rpcconnect;
        }
        catch (Exception e) {
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{reqId, logFlag, e});
            this.rpcstubpool.returnBrokenResource(reqId, rpcconnect);
            return null;
        }
    }

    public String getserver(long reqId, String caller, String clientId, String ext) {
        RpcClientInfo<PushManagerStub.Client> ci;
        String logFlag;
        block8: {
            logFlag = "PMClient.getserver";
            logger.info("[lid:{}][{}] >> user:{}", new Object[]{reqId, logFlag, clientId});
            ci = null;
            try {
                ci = this.getServiceClient(reqId);
                if (ci != null) break block8;
                logger.error("[lid:{}][{}]getServiceClient is null while getServer(user:{}) ", new Object[]{reqId, logFlag, clientId});
                return null;
            }
            catch (TException e) {
                this.rpcstubpool.returnBrokenResource(reqId, ci);
                logger.warn("[lid:{}][{}]exception happened while getServer(clientId:{}) exception detailed:{}...", new Object[]{reqId, logFlag, clientId, e});
                return null;
            }
        }
        ResStr res = ci.getClient().getServer(reqId, caller, clientId, ext);
        JSONObject jExt = Utils.str2Json(reqId, res.ext);
        String req_id = null;
        if (jExt != null) {
            req_id = jExt.getString("reqid");
        }
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}][{}] clientId:{}, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, clientId, res.res, res.value, req_id});
        } else if (res.res == ReturnValues.REQUEST_TOOFAST) {
            logger.warn("[lid:{}][{}]network busy!, clientId:{}, result:{}, request id:{}", new Object[]{reqId, logFlag, clientId, res.value, req_id});
        } else {
            logger.warn("[lid:{}][{}]getServer failed!, clientId:{}, result:{}, request id:{}", new Object[]{reqId, logFlag, clientId, res.value, req_id});
        }
        this.rpcstubpool.returnResource(reqId, ci);
        return res.value;
    }

    public int checkOnlineStatus(long reqId, String caller, String clientId, String ext) {
        String logFlag = "PMClient.checkOnlineStatus";
        logger.info("[lid:{}][{}] >> user:{}", new Object[]{reqId, logFlag, clientId});
        RpcClientInfo<PushManagerStub.Client> ci = null;
        try {
            ci = this.getServiceClient(reqId);
            if (ci == null) {
                logger.warn("[lid:{}][{}] id:{} cann't get pushmanager Client", (Object)reqId, (Object)logFlag);
                return DefaultValues.USER_STATE_ERROR;
            }
            ResInt res = ci.getClient().checkOnlineStatus(reqId, caller, clientId, null);
            JSONObject jExt = Utils.str2Json(reqId, res.ext);
            String req_id = null;
            if (jExt != null) {
                req_id = jExt.getString("reqid");
            }
            if (res.res == ReturnValues.SUCCESS) {
                logger.debug("[lid:{}][{}] sucess! clientId:{}, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, clientId, res.res, res.value, req_id});
            } else if (res.res == ReturnValues.REQUEST_TOOFAST) {
                logger.warn("[lid:{}][{}]network busy! clientId:{}, result:{}, request id:{}", new Object[]{reqId, logFlag, clientId, res.value, req_id});
            } else {
                logger.warn("[lid:{}][{}] failed! clientId:{}, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, clientId, res.res, res.value, req_id});
            }
            this.rpcstubpool.returnResource(reqId, ci);
            return res.value;
        }
        catch (TException e) {
            this.rpcstubpool.returnBrokenResource(reqId, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:\n{}", new Object[]{reqId, logFlag, e});
            return DefaultValues.USER_STATE_ERROR;
        }
    }

    public List<String> getMsg(long reqId, String caller, String user, String startId, int quantity, String ext) {
        RpcClientInfo<PushManagerStub.Client> ci;
        String logFlag;
        block10: {
            logFlag = "PMClient.getMsg";
            logger.info("[lid:{}][{}] >> user:{}", new Object[]{reqId, logFlag, user});
            ci = null;
            try {
                ci = this.getServiceClient(reqId);
                if (ci != null) break block10;
                logger.warn("[lid:{}][{}]getServiceClient is null while getMsg(quantity:{}, startId:{}, user:{})  ", new Object[]{reqId, logFlag, quantity, startId, user});
                return null;
            }
            catch (TException e) {
                this.rpcstubpool.returnBrokenResource(reqId, ci);
                logger.warn("[lid:{}][{}]exception happened while getMsg(quantity:{}, startId:{}, user:{})  exception detailed:{}...", new Object[]{reqId, logFlag, quantity, startId, user, e});
                return null;
            }
        }
        ResListStr res = ci.getClient().getMsg(reqId, caller, user, startId, quantity, ext);
        JSONObject jExt = Utils.str2Json(reqId, res.ext);
        String req_id = null;
        if (jExt != null) {
            req_id = jExt.getString("reqid");
        }
        if (ReturnValues.SUCCESS == res.res) {
            logger.debug("[lid:{}][{}] sucess! user:{}, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, user, res.res, res.value, req_id});
        } else if (ReturnValues.NO_CONTENT == res.res) {
            logger.info("[lid:{}][{}] no content! , user:{}, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, user, res.res, res.value, req_id});
        } else if (res.res == ReturnValues.REQUEST_TOOFAST) {
            logger.warn("[lid:{}][{}]network busy! user:{}, result:{}, request id:{}", new Object[]{reqId, logFlag, user, res.res, req_id});
        } else {
            logger.warn("[lid:{}][{}] can't get msg, user:{}, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, user, res.res, res.value, req_id});
        }
        this.rpcstubpool.returnResource(reqId, ci);
        return res.value;
    }

    public Result<List<String>> sendMsg(long reqId, String caller, String msg, List<String> dstUsers, int sendMode, String ext) {
        String logFlag = "PMClient.sendMsg";
        logger.info("[lid:{}][{}] >> msg:{}, dstUsers:{}, sendMode:{}", new Object[]{reqId, logFlag, msg, dstUsers, sendMode});
        RpcClientInfo<PushManagerStub.Client> ci = null;
        long req_id = -1L;
        long msg_id = -1L;
        try {
            ci = this.getServiceClient(reqId);
            if (ci == null) {
                logger.warn("[lid:{}][{}] getServiceClient is null when sendMsg msg:{},user:{}", new Object[]{reqId, logFlag, msg, dstUsers});
                return new Result<Object>(ReturnValues.INNER_ERROR, req_id, msg_id, null, err2reason.get(ReturnValues.INNER_ERROR));
            }
            ResListStr res = ci.getClient().sendMsg(reqId, caller, msg, dstUsers, sendMode, ext);
            JSONObject jExt = Utils.str2Json(reqId, res.ext);
            if (jExt != null) {
                req_id = jExt.getLongValue("reqid");
                msg_id = jExt.getLongValue("msgid");
            }
            if (res.res == ReturnValues.SUCCESS) {
                logger.debug("[lid:{}][{}] sendMsg success! result:{}, request id:{}", new Object[]{reqId, logFlag, res.res, req_id});
            } else if (res.res == ReturnValues.REQUEST_TOOFAST) {
                logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            } else {
                logger.warn("[lid:{}][{}] sendMsg failed! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            }
            this.rpcstubpool.returnResource(reqId, ci);
            return new Result<List<String>>(res.res, req_id, msg_id, res.value, err2reason.get(res.res));
        }
        catch (Exception e) {
            this.rpcstubpool.returnBrokenResource(reqId, ci);
            logger.warn("[lid:{}][{}]exception happened while sendMsg exception detailed:{}...", new Object[]{reqId, logFlag, e});
            return new Result<Object>(ReturnValues.INNER_ERROR, req_id, msg_id, null, err2reason.get(ReturnValues.INNER_ERROR));
        }
    }

    public Result<List<String>> sendMsg(long reqId, String caller, Message msg, List<String> dstUsers, int sendMode, String ext) {
        String logFlag = "PMClient.sendMsg";
        logger.info("[lid:{}][{}] >> msg:{}, dstUsers:{}, sendMode:{}", new Object[]{reqId, logFlag, msg, dstUsers, sendMode});
        RpcClientInfo<PushManagerStub.Client> ci = null;
        long req_id = -1L;
        long msg_id = -1L;
        try {
            ci = this.getServiceClient(reqId);
            if (ci == null) {
                logger.warn("[lid:{}][{}] getServiceClient is null when sendMsg msg:{},user:{}", new Object[]{reqId, logFlag, msg, dstUsers});
                return new Result<Object>(ReturnValues.INNER_ERROR, req_id, msg_id, null, err2reason.get(ReturnValues.INNER_ERROR));
            }
            JSONObject joMsg = new JSONObject();
            joMsg.put("sid", (Object)msg.getSid());
            joMsg.put("con", (Object)msg.getCon());
            joMsg.put("exp", (Object)msg.getExp());
            joMsg.put("st", (Object)msg.getSt());
            ResListStr res = ci.getClient().sendMsg(reqId, caller, joMsg.toJSONString(), dstUsers, sendMode, ext);
            JSONObject jExt = Utils.str2Json(reqId, res.ext);
            if (jExt != null) {
                req_id = jExt.getLongValue("reqid");
                msg_id = jExt.getLongValue("msgid");
            }
            if (res.res == ReturnValues.SUCCESS) {
                logger.debug("[lid:{}][{}] sendMsg success! result:{}, request id:{}", new Object[]{reqId, logFlag, res.res, req_id});
            } else if (res.res == ReturnValues.REQUEST_TOOFAST) {
                logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            } else {
                logger.warn("[lid:{}][{}] sendMsg failed! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            }
            this.rpcstubpool.returnResource(reqId, ci);
            return new Result<List<String>>(res.res, req_id, msg_id, res.value, err2reason.get(res.res));
        }
        catch (Exception e) {
            this.rpcstubpool.returnBrokenResource(reqId, ci);
            logger.warn("[lid:{}][{}]exception happened while sendMsg exception detailed:{}...", new Object[]{reqId, logFlag, e});
            return new Result<Object>(ReturnValues.INNER_ERROR, req_id, msg_id, null, err2reason.get(ReturnValues.INNER_ERROR));
        }
    }

    public long sendAMsg(long reqId, String caller, String msg, String dstUser, int sendMode, String ext) {
        RpcClientInfo<PushManagerStub.Client> ci;
        String logFlag;
        block7: {
            logFlag = "PMClient.sendAMsg";
            logger.info("[lid:{}][{}] >> msg:{}, dstUsers:{}, sendMode:{}", new Object[]{reqId, logFlag, msg, dstUser, sendMode});
            ci = null;
            try {
                ci = this.getServiceClient(reqId);
                if (ci != null) break block7;
                logger.warn("[lid:{}][{}] getServiceClient is null when sendMsg msg:{},user:{}", new Object[]{reqId, logFlag, msg, dstUser});
                return -1L;
            }
            catch (Exception e) {
                this.rpcstubpool.returnBrokenResource(reqId, ci);
                logger.warn("[lid:{}][{}]exception happened while sendMsg exception detailed:{}...", new Object[]{reqId, logFlag, e});
                return -1L;
            }
        }
        ResLong res = ci.getClient().sendAMsg(reqId, caller, msg, dstUser, sendMode, ext);
        JSONObject jExt = Utils.str2Json(reqId, res.ext);
        String req_id = null;
        if (jExt != null) {
            req_id = jExt.getString("reqid");
        }
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}][{}] result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            this.rpcstubpool.returnResource(reqId, ci);
            return res.value;
        }
        if (res.res == ReturnValues.REQUEST_TOOFAST) {
            logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        } else {
            logger.warn("[lid:{}][{}] sendAMsg failed!, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        }
        this.rpcstubpool.returnResource(reqId, ci);
        return -1L;
    }

    public long sendAMsg(long reqId, String caller, Message msg, String dstUser, int sendMode, String ext) {
        RpcClientInfo<PushManagerStub.Client> ci;
        String logFlag;
        block7: {
            logFlag = "PMClient.sendAMsg";
            logger.info("[lid:{}][{}] >> msg:{}, dstUsers:{}, sendMode:{}", new Object[]{reqId, logFlag, msg, dstUser, sendMode});
            ci = null;
            try {
                ci = this.getServiceClient(reqId);
                if (ci != null) break block7;
                logger.warn("[lid:{}][{}] getServiceClient is null when sendMsg msg:{},user:{}", new Object[]{reqId, logFlag, msg, dstUser});
                return -1L;
            }
            catch (Exception e) {
                this.rpcstubpool.returnBrokenResource(reqId, ci);
                logger.warn("[lid:{}][{}]exception happened while sendMsg exception detailed:{}...", new Object[]{reqId, logFlag, e});
                return -1L;
            }
        }
        JSONObject joMsg = new JSONObject();
        joMsg.put("sid", (Object)msg.getSid());
        joMsg.put("con", (Object)msg.getCon());
        joMsg.put("exp", (Object)msg.getExp());
        joMsg.put("st", (Object)msg.getSt());
        ResLong res = ci.getClient().sendAMsg(reqId, caller, joMsg.toJSONString(), dstUser, sendMode, ext);
        JSONObject jExt = Utils.str2Json(reqId, res.ext);
        String req_id = null;
        if (jExt != null) {
            req_id = jExt.getString("reqid");
        }
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}][{}] result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            this.rpcstubpool.returnResource(reqId, ci);
            return res.value;
        }
        if (res.res == ReturnValues.REQUEST_TOOFAST) {
            logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        } else {
            logger.warn("[lid:{}][{}] sendAMsg failed!, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        }
        this.rpcstubpool.returnResource(reqId, ci);
        return -1L;
    }

    public int delMsg(long reqId, String caller, String user, String startId, int quantity, String ext) {
        RpcClientInfo<PushManagerStub.Client> ci;
        String logFlag;
        block8: {
            logFlag = "PMClient.delMsg";
            logger.info("[lid:{}][{}] >> caller:{}, user:{}", new Object[]{reqId, logFlag, caller, user});
            ci = null;
            try {
                ci = this.getServiceClient(reqId);
                if (ci != null) break block8;
                logger.warn("[lid:{}][{}]getServiceClient is null while delMsg(quantity:{}, startId:{}, user:{})", new Object[]{reqId, logFlag, quantity, startId, user});
                return -1;
            }
            catch (Exception e) {
                this.rpcstubpool.returnBrokenResource(reqId, ci);
                logger.warn("[lid:{}][{}]exception happened while delMsg(quantity:{}, startId:{}, user:{})  exception detailed:{}...", new Object[]{reqId, logFlag, quantity, startId, user, e});
                return -1;
            }
        }
        ResInt delNum = ci.getClient().delMsg(reqId, caller, user, startId, quantity, ext);
        JSONObject jExt = Utils.str2Json(reqId, delNum.ext);
        String req_id = null;
        if (jExt != null) {
            req_id = jExt.getString("reqid");
        }
        if (delNum.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}][{}] sucess! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, delNum.res, delNum.value, req_id});
        } else if (delNum.res == ReturnValues.REQUEST_TOOFAST) {
            logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, delNum.res, delNum.value, req_id});
        } else {
            logger.warn("[lid:{}][{}] delete message failed! result:{},value:{}, request id:{}", new Object[]{reqId, logFlag, delNum.res, delNum.value, req_id});
        }
        this.rpcstubpool.returnResource(reqId, ci);
        return delNum.value;
    }

    public String echo(long reqId, String caller, String srcStr, String ext) {
        RpcClientInfo<PushManagerStub.Client> ci;
        String logFlag;
        block8: {
            logFlag = "PMClient.echo";
            ci = null;
            try {
                ci = this.getServiceClient(reqId);
                if (ci != null) break block8;
                logger.warn("[lid:{}][{}]getServiceClient is null while echo(caller:{}, srcStr:{})", new Object[]{reqId, logFlag, caller, srcStr});
                return null;
            }
            catch (Exception e) {
                this.rpcstubpool.returnBrokenResource(reqId, ci);
                logger.warn("[lid:{}][{}]exception happened while echo(caller:{}, srcStr:{}})  exception detailed:{}...", new Object[]{reqId, logFlag, caller, srcStr, e});
                return null;
            }
        }
        ResStr res = ci.getClient().echo(reqId, caller, srcStr, ext);
        JSONObject jExt = Utils.str2Json(reqId, res.ext);
        String req_id = null;
        if (jExt != null) {
            req_id = jExt.getString("reqid");
        }
        if (res.res == ReturnValues.SUCCESS) {
            logger.debug("[lid:{}][{}] sucess! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        } else if (res.res == ReturnValues.REQUEST_TOOFAST) {
            logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        } else {
            logger.warn("[lid:{}][{}]get echo failed! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        }
        this.rpcstubpool.returnResource(reqId, ci);
        return res.value;
    }

    public Map<String, String> checkBatchOnlineStatus(long reqId, String caller, List<String> dstUsers, String ext) {
        String logFlag = "PMClient.checkBatchOnlineStatus";
        RpcClientInfo<PushManagerStub.Client> ci = null;
        logger.debug("[lid:{}][{}] >> dstUsers:{}", new Object[]{reqId, logFlag, dstUsers});
        HashMap<String, String> map = null;
        try {
            map = new HashMap<String, String>();
            ci = this.getServiceClient(reqId);
            if (ci == null) {
                logger.warn("[lid:{}][{}] id:{} cann't get pushmanager Client", (Object)reqId, (Object)logFlag);
                return map;
            }
            ResMapStrStr res = ci.getClient().checkBatchOnlineStatus(reqId, caller, dstUsers, ext);
            JSONObject jExt = Utils.str2Json(reqId, res.ext);
            String req_id = null;
            if (jExt != null) {
                req_id = jExt.getString("reqid");
            }
            if (res.res == ReturnValues.SUCCESS) {
                logger.debug("[lid:{}][{}] sucess! result:{}, request id:{}", new Object[]{reqId, logFlag, res.value, req_id});
            } else if (res.res == ReturnValues.REQUEST_TOOFAST) {
                logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            } else {
                logger.warn("[lid:{}][{}] fail, result:{} value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            }
            this.rpcstubpool.returnResource(reqId, ci);
            return res.value;
        }
        catch (TException e) {
            this.rpcstubpool.returnBrokenResource(reqId, ci);
            logger.warn("[lid:{}][{}] exception happened! detail:{}", new Object[]{reqId, logFlag, e});
            return map;
        }
    }

    public Result<Long> asyncSendMsg(long reqId, String caller, String msg, Set<String> dstUsers, int sendMode, String ext) {
        String logFlag = "PMClient.asyncSendMsg";
        logger.info("[lid:{}][{}] >> msg:{}, dstUsers:{}, sendMode:{}", new Object[]{reqId, logFlag, msg, dstUsers, sendMode});
        RpcClientInfo<PushManagerStub.Client> ci = null;
        long req_id = -1L;
        long msg_id = -1L;
        try {
            ci = this.getServiceClient(reqId);
            if (ci == null) {
                logger.warn("[lid:{}][{}] getServiceClient is null when asyncSendMsg msg:{},user:{}", new Object[]{reqId, logFlag, msg, dstUsers});
                return new Result<Long>(ReturnValues.INNER_ERROR, req_id, msg_id, -1L, err2reason.get(ReturnValues.INNER_ERROR));
            }
            ResLong res = ci.getClient().asyncSendMsg(reqId, caller, msg, dstUsers, sendMode, ext);
            JSONObject jExt = Utils.str2Json(reqId, res.ext);
            if (jExt != null) {
                req_id = jExt.getLongValue("reqid");
            }
            if (ReturnValues.SUCCESS == res.res) {
                logger.debug("[lid:{}][{}] result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            } else if (ReturnValues.REQUEST_TOOFAST == res.res) {
                logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            } else {
                logger.warn("[lid:{}][{}] asyncSendMsg failed!, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            }
            this.rpcstubpool.returnResource(reqId, ci);
            return new Result<Long>(res.res, req_id, msg_id, res.value, err2reason.get(res.res));
        }
        catch (Exception e) {
            this.rpcstubpool.returnBrokenResource(reqId, ci);
            logger.warn("[lid:{}][{}]exception happened while asyncSendMsg exception detailed:{}...", new Object[]{reqId, logFlag, e});
            return new Result<Long>(ReturnValues.INNER_ERROR, req_id, msg_id, -1L, err2reason.get(ReturnValues.INNER_ERROR));
        }
    }

    public Result<Long> asyncSendMsg(long reqId, String caller, Message msg, Set<String> dstUsers, int sendMode, String ext) {
        String logFlag = "PMClient.asyncSendMsg";
        logger.info("[lid:{}][{}] >> msg:{}, dstUsers:{}, sendMode:{}", new Object[]{reqId, logFlag, msg, dstUsers, sendMode});
        RpcClientInfo<PushManagerStub.Client> ci = null;
        long req_id = -1L;
        long msg_id = -1L;
        try {
            ci = this.getServiceClient(reqId);
            if (ci == null) {
                logger.warn("[lid:{}][{}] getServiceClient is null when asyncSendMsg msg:{},user:{}", new Object[]{reqId, logFlag, msg, dstUsers});
                return new Result<Long>(ReturnValues.INNER_ERROR, req_id, msg_id, -1L, err2reason.get(ReturnValues.INNER_ERROR));
            }
            JSONObject joMsg = new JSONObject();
            joMsg.put("sid", (Object)msg.getSid());
            joMsg.put("con", (Object)msg.getCon());
            joMsg.put("exp", (Object)msg.getExp());
            joMsg.put("st", (Object)msg.getSt());
            ResLong res = ci.getClient().asyncSendMsg(reqId, caller, joMsg.toJSONString(), dstUsers, sendMode, ext);
            JSONObject jExt = Utils.str2Json(reqId, res.ext);
            if (jExt != null) {
                req_id = jExt.getLongValue("reqid");
            }
            if (ReturnValues.SUCCESS == res.res) {
                logger.debug("[lid:{}][{}] result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            } else if (ReturnValues.REQUEST_TOOFAST == res.res) {
                logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            } else {
                logger.warn("[lid:{}][{}] asyncSendMsg failed!, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            }
            this.rpcstubpool.returnResource(reqId, ci);
            return new Result<Long>(res.res, req_id, msg_id, res.value, err2reason.get(res.res));
        }
        catch (Exception e) {
            this.rpcstubpool.returnBrokenResource(reqId, ci);
            logger.warn("[lid:{}][{}]exception happened while asyncSendMsg exception detailed:{}...", new Object[]{reqId, logFlag, e});
            return new Result<Long>(ReturnValues.INNER_ERROR, req_id, msg_id, -1L, err2reason.get(ReturnValues.INNER_ERROR));
        }
    }

    public Map<String, String> queryMsgStatus(long reqId, String caller, long msgId, String ext) {
        RpcClientInfo<PushManagerStub.Client> ci;
        String logFlag;
        block7: {
            logFlag = "PMClient.queryMsgStatus";
            logger.info("[lid:{}][{}] >> msgId:{}", new Object[]{reqId, logFlag, msgId});
            ci = null;
            try {
                ci = this.getServiceClient(reqId);
                if (ci != null) break block7;
                logger.warn("[lid:{}][{}] getServiceClient is null when queryMsgStatus msgId:{}", new Object[]{reqId, logFlag, msgId});
                return null;
            }
            catch (Exception e) {
                this.rpcstubpool.returnBrokenResource(reqId, ci);
                logger.warn("[lid:{}][{}]exception happened while queryMsgStatus exception detailed:{}...", new Object[]{reqId, logFlag, e});
                return null;
            }
        }
        ResMapStrStr res = ci.getClient().queryMsgStatus(reqId, caller, msgId, ext);
        JSONObject jExt = Utils.str2Json(reqId, res.ext);
        String req_id = null;
        if (jExt != null) {
            req_id = jExt.getString("reqid");
        }
        if (ReturnValues.SUCCESS == res.res) {
            logger.debug("[lid:{}][{}] result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
            this.rpcstubpool.returnResource(reqId, ci);
            return res.value;
        }
        if (ReturnValues.REQUEST_TOOFAST == res.res) {
            logger.warn("[lid:{}][{}]network busy! result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        } else {
            logger.warn("[lid:{}][{}] queryMsgStatus failed!, result:{}, value:{}, request id:{}", new Object[]{reqId, logFlag, res.res, res.value, req_id});
        }
        this.rpcstubpool.returnResource(reqId, ci);
        return null;
    }

    public void shutDown(long reqId) {
        String logFlag = "PMClient.shutDown";
        if (this.rpcstubpool == null) {
            return;
        }
        try {
            this.rpcstubpool.destroy(reqId);
            this.rpcstubpool = null;
        }
        catch (Exception ex) {
            logger.error("[lid:{}][{}]exception happened while shutting down rpcstubpool...", (Object)reqId, (Object)logFlag);
        }
    }
}

