/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pushmanagerclient.start;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pushmanagerclient.common.ReturnValues;
import com.xdja.pushmanagerclient.common.Utils;
import com.xdja.pushmanagerclient.start.Message;
import com.xdja.pushmanagerclient.start.PMClient;
import com.xdja.pushmanagerclient.start.Result;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMClientTest {
    private static Logger logger = LoggerFactory.getLogger(PMClient.class);
    private static final String THRIFT_HOST = "11.12.112.88";
    private static final int THRIFT_PORT = 5818;
    int serverMode = 3;
    private long reqId = -1L;
    PMClient pmclient = null;
    String clientId = "xdja/d/750013";
    String topic = "xdja/d/750013/ps";

    public boolean init() {
        String logFlag = "PMClient.init";
        logger.debug("[lid:{}][{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{-1, logFlag, THRIFT_HOST, 5818, this.serverMode});
        this.pmclient = new PMClient(THRIFT_HOST, 5818);
        return this.pmclient.init(this.reqId);
    }

    @Test
    public void test_init() {
        String logFlag = "PMClient.test_init";
        logger.debug("[lid:{}][{}] serverHost:{} serverPort:{} serverMode:{}", new Object[]{-1, logFlag, THRIFT_HOST, 5818, this.serverMode});
        PMClient pmclient = new PMClient(THRIFT_HOST, 5818);
        Assert.assertTrue((boolean)pmclient.init(this.reqId));
    }

    @Test
    public void test_getserver() {
        String strRe;
        String logFlag = "PMClient.test_getserver";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        Assert.assertTrue(((strRe = this.pmclient.getserver(this.reqId, "test_getserver", "xdja/d/750013", null)) != null ? 1 : 0) != 0);
        JSONObject jobj = Utils.str2Json(this.reqId, strRe);
        logger.info("[lid:{}][{}] host:{} port:{} key:{}", new Object[]{-1, logFlag, jobj.getString("host"), jobj.getInteger("port"), jobj.getString("key")});
    }

    @Test
    public void test_getserverAll() {
        String logFlag = "PMClient.test_getserver";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        ArrayList<String> clientIds = new ArrayList<String>();
        clientIds.add("xdja/d/75002");
        clientIds.add("xdja/d/75003");
        clientIds.add("xdja/d/75004");
        String strRe = this.pmclient.getserver(this.reqId, "test_getserver", "xdja/d/750013", null);
        Assert.assertTrue((strRe != null ? 1 : 0) != 0);
        JSONObject jobj = Utils.str2Json(this.reqId, strRe);
        logger.info("[lid:{}][{}] host:{} port:{} key:{}", new Object[]{-1, logFlag, jobj.getString("host"), jobj.getInteger("port"), jobj.getString("key")});
    }

    @Test
    public void test_checkOnlineStatus() {
        int iRe;
        String logFlag = "PMClient.test_checkOnlineStatus";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        Assert.assertTrue(((iRe = this.pmclient.checkOnlineStatus(this.reqId, "test_checkOnlineStatus", this.clientId, null)) != -1 ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] result:{}", new Object[]{-1, logFlag, iRe});
    }

    @Test
    public void test_checkBatchOnlineStatus() {
        String logFlag = "PMClient.test_checkBatchOnlineStatus";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        ArrayList<String> dstUsers = new ArrayList<String>();
        dstUsers.add("xdja/d/13625");
        dstUsers.add("xdja/d/123");
        dstUsers.add("xdja/d/456");
        dstUsers.add("xdja/d/45678945666/im");
        dstUsers.add("xdja/d/45678945666");
        Map<String, String> mRe = this.pmclient.checkBatchOnlineStatus(this.reqId, "test_checkBatchOnlineStatus", dstUsers, null);
        Assert.assertTrue((!mRe.isEmpty() ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] result:{}", new Object[]{-1, logFlag, mRe});
    }

    @Test
    public void test_echo() {
        String strRe;
        String logFlag = "PMClient.test_echo";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        Assert.assertTrue(((strRe = this.pmclient.echo(this.reqId, "test_echo", "helo", null)) != null ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] result:{}", new Object[]{-1, logFlag, strRe});
    }

    @Test
    public void test_getMsg() {
        String logFlag = "PMClient.test_getMsg";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        JSONObject joMsg = new JSONObject();
        joMsg.put("sid", (Object)"xdja/d/10001/im");
        joMsg.put("con", (Object)"hello joniers.jia");
        joMsg.put("exp", (Object)10000000);
        joMsg.put("st", (Object)System.currentTimeMillis());
        ArrayList<String> dstUsers = new ArrayList<String>();
        dstUsers.add("xdja/d/75002/im");
        dstUsers.add("xdja/d/75003/im");
        dstUsers.add("xdja/d/75004/im");
        Result<List<String>> lRe = this.pmclient.sendMsg(this.reqId, "test_getMsg", joMsg.toJSONString(), dstUsers, 2, null);
        Assert.assertTrue((lRe.getErrcode() == ReturnValues.SUCCESS ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] test_getMsg result:{}", new Object[]{-1, logFlag, lRe});
        for (String aUser : dstUsers) {
            List<String> listgm = this.pmclient.getMsg(this.reqId, "test_getMsg", aUser, null, 300, null);
            Assert.assertTrue((listgm != null ? 1 : 0) != 0);
            logger.info("[lid:{}][{}] test_getMsg user:{} result:{}", new Object[]{-1, logFlag, aUser, listgm});
        }
    }

    @Test
    public void test_sendMsg() {
        String logFlag = "PMClient.test_sendMsg";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        JSONObject joMsg = new JSONObject();
        joMsg.put("sid", (Object)"xdja/d/10001/im");
        joMsg.put("con", (Object)"hello joniers.jia");
        joMsg.put("exp", (Object)10000000);
        joMsg.put("st", (Object)System.currentTimeMillis());
        ArrayList<String> dstUsers = new ArrayList<String>();
        dstUsers.add("xdja/d/75002/im");
        dstUsers.add("xdja/d/75003/im");
        dstUsers.add("xdja/d/75004/im");
        Result<List<String>> lRe = this.pmclient.sendMsg(this.reqId, "test_sendMsg", joMsg.toJSONString(), dstUsers, 2, null);
        Assert.assertTrue((lRe.getErrcode() == ReturnValues.SUCCESS ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] test_sendMsg result:{}", new Object[]{-1, logFlag, lRe.getValue()});
    }

    @Test
    public void test_sendMsgNew() {
        String logFlag = "PMClient.test_sendMsgNew";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        Message msg = new Message.Builder().sid("xdja/d/10001/im").con("hello").exp(10000000L).st(System.currentTimeMillis()).build();
        ArrayList<String> dstUsers = new ArrayList<String>();
        dstUsers.add("xdja/d/75002/im");
        dstUsers.add("xdja/d/75003/im");
        dstUsers.add("xdja/d/75004/im");
        Result<List<String>> lRe = this.pmclient.sendMsg(this.reqId, "test_sendMsgNew", msg, dstUsers, 2, null);
        Assert.assertTrue((lRe.getErrcode() == ReturnValues.SUCCESS ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] test_sendMsgNew result:{}", new Object[]{-1, logFlag, lRe.getValue()});
    }

    @Test
    public void test_sendAMsg() {
        String logFlag = "PMClient.test_sendAMsg";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        JSONObject joMsg = new JSONObject();
        joMsg.put("sid", (Object)"xdja/d/10001/im");
        joMsg.put("con", (Object)"hello joniers.jia");
        joMsg.put("exp", (Object)10000000);
        joMsg.put("st", (Object)System.currentTimeMillis());
        String dstUser = "xdja/d/750013/im";
        long res = this.pmclient.sendAMsg(this.reqId, "test_sendAMsg", joMsg.toJSONString(), dstUser, 2, null);
        Assert.assertTrue((res != -1L ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] test_sendAMsg result:{}", new Object[]{-1, logFlag, res});
    }

    @Test
    public void test_sendAMsgNew() {
        String dstUser;
        Message msg;
        long res;
        String logFlag = "PMClient.test_sendAMsgNew";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        Assert.assertTrue(((res = this.pmclient.sendAMsg(this.reqId, "test_sendAMsgNew", msg = new Message.Builder().sid("xdja/d/10001/im").con("hello").exp(10000000L).st(System.currentTimeMillis()).build(), dstUser = "xdja/d/750013/im", 2, null)) != -1L ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] test_sendAMsgNew result:{}", new Object[]{-1, logFlag, res});
    }

    @Test
    public void test_asyncSendMsg() {
        String logFlag = "PMClient.test_asyncSendMsg";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        HashSet<String> dstUsers = new HashSet<String>();
        dstUsers.add("xdja/d/75002/im");
        dstUsers.add("xdja/d/75003/im");
        dstUsers.add("xdja/d/75004/im");
        JSONObject joMsg = new JSONObject();
        joMsg.put("sid", (Object)"xdja/d/10001/im");
        joMsg.put("con", (Object)"hello joniers.jia");
        joMsg.put("exp", (Object)10000000);
        joMsg.put("st", (Object)System.currentTimeMillis());
        Result<Long> res = this.pmclient.asyncSendMsg(this.reqId, "test_asyncSendMsg", joMsg.toJSONString(), dstUsers, 2, null);
        Assert.assertTrue((res.getValue() != -1L ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] test_sendAMsg result:{}", new Object[]{-1, logFlag, res});
    }

    @Test
    public void test_asyncSendMsgNew() {
        String logFlag = "PMClient.test_asyncSendMsg";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        Message msg = new Message.Builder().sid("xdja/d/10001/im").con("hello").exp(10000000L).st(System.currentTimeMillis()).build();
        HashSet<String> dstUsers = new HashSet<String>();
        dstUsers.add("xdja/d/75002/im");
        dstUsers.add("xdja/d/75003/im");
        dstUsers.add("xdja/d/75004/im");
        Result<Long> res = this.pmclient.asyncSendMsg(this.reqId, "test_asyncSendMsg", msg, dstUsers, 2, null);
        Assert.assertTrue((res.getValue() != -1L ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] test_sendAMsg result:{}", new Object[]{-1, logFlag, res});
    }

    @Test
    public void test_delMsg() {
        String logFlag = "PMClient.test_delMsg";
        if (!this.init()) {
            logger.warn("[lid:{}][{}] init fail!", (Object)this.reqId, (Object)logFlag);
        }
        JSONObject joMsg = new JSONObject();
        joMsg.put("sid", (Object)"xdja/d/10001/im");
        joMsg.put("con", (Object)"hello joniers.jia");
        joMsg.put("exp", (Object)10000000);
        joMsg.put("st", (Object)System.currentTimeMillis());
        ArrayList<String> dstUsers = new ArrayList<String>();
        dstUsers.add("xdja/d/75002/im");
        dstUsers.add("xdja/d/75003/im");
        dstUsers.add("xdja/d/75004/im");
        Result<List<String>> lRe = this.pmclient.sendMsg(this.reqId, "sendMsg", joMsg.toJSONString(), dstUsers, 2, null);
        Assert.assertTrue((lRe.getErrcode() == ReturnValues.SUCCESS ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] sendMsg result:{}", new Object[]{-1, logFlag, lRe.getValue()});
        String startId = null;
        for (String aUser : dstUsers) {
            List<String> listgm = this.pmclient.getMsg(this.reqId, "getMsg", aUser, null, 300, null);
            Assert.assertTrue((listgm != null ? 1 : 0) != 0);
            logger.info("[lid:{}][{}] getMsg user:{} result:{}", new Object[]{-1, logFlag, aUser, listgm});
            JSONObject joFirstMsg = Utils.str2Json(this.reqId, listgm.get(0));
            startId = joFirstMsg.getString("id");
            int delNum = this.pmclient.delMsg(this.reqId, "test_delMsg", aUser, startId, 100, null);
            Assert.assertTrue((delNum != -1 ? 1 : 0) != 0);
            logger.info("[lid:{}][{}] delMsg user:{} result:{}", new Object[]{-1, logFlag, aUser, delNum});
        }
        System.out.println("test error startId\n");
        int delNum = this.pmclient.delMsg(this.reqId, "test_delMsg", "xdja/d/75002/im", "99999999999999", 100, null);
        Assert.assertTrue((delNum != -1 ? 1 : 0) != 0);
        logger.info("[lid:{}][{}] delMsg user:{} result:{}", new Object[]{-1, logFlag, "xdja/d/75002/im", delNum});
    }
}

