/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rpcstubpool;

import com.xdja.pushmanager.stub.PushManagerStub;
import com.xdja.pushmanager.thrift.datatype.ResStr;
import com.xdja.pushmanagerclient.common.DefaultValues;
import com.xdja.pushmanagerclient.common.ReturnValues;
import com.xdja.rpcstubpool.RpcClientInfo;
import com.xdja.rpcstubpool.RpcStubPool;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcStubPushManagerFactory
extends BasePoolableObjectFactory<RpcClientInfo<PushManagerStub.Client>> {
    private final String host;
    private final int port;
    private final int serverMode;
    private final int timeout;
    public AtomicInteger logId = new AtomicInteger(-1);
    private static Logger logger = LoggerFactory.getLogger(RpcStubPushManagerFactory.class);

    private String getClassName() {
        return "RpcStubPushManagerFactory";
    }

    public RpcStubPushManagerFactory(String host, int port, int mode, int timeout) {
        this.host = host;
        this.port = port;
        this.serverMode = mode;
        this.timeout = timeout;
    }

    public RpcClientInfo<PushManagerStub.Client> makeObject() throws Exception {
        String logFlag = String.valueOf(this.getClassName()) + ".makeObject";
        TSocket transport = null;
        TBinaryProtocol protocol = null;
        TSocket tsocket = null;
        if (this.serverMode == DefaultValues.SERVER_MODE_THREAD_POOL) {
            transport = tsocket = new TSocket(this.host, this.port, this.timeout);
            protocol = new TBinaryProtocol((TTransport)transport);
        } else if (this.serverMode == DefaultValues.SERVER_MODE_NONBLOCK || this.serverMode == DefaultValues.SERVER_MODE_THREADEDSELECTOR) {
            tsocket = new TSocket(this.host, this.port, this.timeout);
            transport = new TFramedTransport((TTransport)tsocket);
            protocol = new TBinaryProtocol((TTransport)transport);
        }
        RpcClientInfo<PushManagerStub.Client> rpctype = new RpcClientInfo<PushManagerStub.Client>(new PushManagerStub.Client((TProtocol)protocol), (TTransport)transport, tsocket);
        try {
            rpctype.getTTransport().open();
            RpcStubPool.iNum.incrementAndGet();
            return rpctype;
        }
        catch (TTransportException e) {
            logger.warn("[lid:{}][{}]getTTransport failed! TTransportException detail:{}", new Object[]{this.logId.getAndDecrement(), logFlag, e});
            return null;
        }
    }

    public void destroyObject(RpcClientInfo<PushManagerStub.Client> obj) throws Exception {
        String logFlag = String.valueOf(this.getClassName()) + ".destroyObject";
        if (obj == null) {
            logger.warn("[lid:{}][{}]Object is empty!", (Object)this.logId.getAndDecrement(), (Object)logFlag);
            return;
        }
        RpcClientInfo<PushManagerStub.Client> rpctype = obj;
        rpctype.getTTransport().close();
        RpcStubPool.iNum.decrementAndGet();
    }

    public boolean validateObject(RpcClientInfo<PushManagerStub.Client> obj) {
        ResStr resStr;
        block6: {
            RpcClientInfo<PushManagerStub.Client> rpctype;
            String logFlag;
            block5: {
                logFlag = String.valueOf(this.getClassName()) + ".validateObject";
                this.logId.getAndIncrement();
                if (obj == null) {
                    logger.warn("[lid:{}][{}]Object is empty!", (Object)this.logId.get(), (Object)logFlag);
                    return false;
                }
                try {
                    rpctype = obj;
                    if (this.checkSocket(rpctype.getTSocket().getSocket())) break block5;
                    logger.warn("[lid:{}][{}] checkSocket fail!", (Object)this.logId.get(), (Object)logFlag);
                    return false;
                }
                catch (Exception e) {
                    logger.warn("[lid:{}][{}]validateObject fail! Exception detail:{}", new Object[]{this.logId.get(), logFlag, e});
                    return false;
                }
            }
            resStr = rpctype.getClient().echo(this.logId.get(), logFlag, "OK", null);
            if (resStr.res == ReturnValues.SUCCESS) break block6;
            logger.warn("[lid:{}][{}] err result!", (Object)this.logId.get(), (Object)logFlag);
            return false;
        }
        return resStr.value.equals("OK");
    }

    public boolean checkSocket(Socket socket) {
        return socket != null && socket.isBound() && !socket.isClosed() && socket.isConnected() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }
}

