/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.api;

import com.xdja.rcs.sc.client.api.Slf4jUnrecoverableMessageLogger;
import com.xdja.rcs.sc.client.api.UnrecoverableMessageLogger;
import com.xdja.rcs.sc.client.core.ScClient;
import com.xdja.rcs.sc.client.core.config.node.ScServerNode;
import com.xdja.rcs.sc.client.core.consumer.MessageCallback;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.rcs.sc.remoting.exception.RemotingSendRequestException;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScClientAPI {
    private static final Logger logger = LoggerFactory.getLogger(ScClientAPI.class);
    private static UnrecoverableMessageLogger msgLogger = new Slf4jUnrecoverableMessageLogger();
    private static final ExecutorService es = Executors.newCachedThreadPool();

    public static void initClient(String configFilePath) throws UnrecoverableException {
        if (StringUtils.isBlank((CharSequence)configFilePath)) {
            throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u53c2\u6570configFilePath\u4e3a\u7a7a");
        }
        ScClientAPI.initClient(new File(configFilePath));
    }

    public static void initClient(File configFile) throws UnrecoverableException {
        if (null == configFile) {
            throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u53c2\u6570configFile\u4e3a\u7a7a");
        }
        ScClient.getInstance().initClient(configFile);
    }

    public static void setUnrecoverableMessageLogger(UnrecoverableMessageLogger msgLogger) {
        if (null != msgLogger) {
            ScClientAPI.msgLogger = msgLogger;
        }
    }

    public static void logUnrecoverableMsg(final ScServerNode server, final Message msg, final String reason) {
        es.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (null == msg) {
                        msgLogger.log(server, reason);
                    } else {
                        msgLogger.log(server, msg, reason);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static void logUnrecoverableMsg(final ScServerNode server, final Message msg, final Throwable reason) {
        es.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (null == msg) {
                        msgLogger.log(server, reason);
                    } else {
                        msgLogger.log(server, msg, reason);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static String reqMsgId(String scServerId) throws UnrecoverableException {
        if (StringUtils.isBlank((CharSequence)scServerId)) {
            throw UnrecoverableException.create((String)"\u83b7\u53d6\u6d88\u606f\u6807\u8bc6\u5931\u8d25\uff1a\u4f20\u5165\u7684\u53c2\u6570\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a");
        }
        if (!ScClient.getInstance().isInitialized()) {
            throw UnrecoverableException.create((String)"\u83b7\u53d6\u6d88\u606f\u6807\u8bc6\u5931\u8d25\uff1a\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u672a\u521d\u59cb\u5316");
        }
        return ScClient.getInstance().getProducer().calculateMsgId(scServerId);
    }

    public static void registerMsgCallback(MessageCallback ... msgCallbacks) throws UnrecoverableException {
        if (!ScClient.getInstance().isInitialized()) {
            throw UnrecoverableException.create((String)"\u6ce8\u518c\u6d88\u606f\u56de\u8c03\u5931\u8d25\uff1a\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u672a\u521d\u59cb\u5316");
        }
        if (null == ScClient.getInstance().getConsumer()) {
            throw UnrecoverableException.create((String)"\u6ce8\u518c\u6d88\u606f\u56de\u8c03\u5931\u8d25\uff1a\u8be5\u5e94\u7528\u4e0d\u5177\u6709\u6d88\u8d39\u8005\u89d2\u8272");
        }
        ScClient.getInstance().getConsumer().addMsgCallback(msgCallbacks);
    }

    public static void sendMessage(String scServerId, Message message) throws UnrecoverableException, IllegalArgumentException {
        if (!ScClient.getInstance().isInitialized()) {
            throw UnrecoverableException.create((String)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u672a\u521d\u59cb\u5316");
        }
        if (null == ScClient.getInstance().getProducer()) {
            throw UnrecoverableException.create((String)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a\u8be5\u5e94\u7528\u4e0d\u5177\u6709\u751f\u4ea7\u8005\u89d2\u8272");
        }
        logger.debug("\u5e94\u7528\uff08\u751f\u4ea7\u8005\uff09\u5411\u8ba2\u9605\u4e2d\u5fc3\u53d1\u9001\u6d88\u606f{}", (Object)message.getMsgId());
        try {
            ScClient.getInstance().getProducer().sendMessage(scServerId, message);
        }
        catch (RemotingSendRequestException e) {
            if (e.isRecoverable()) {
                ScClient.getInstance().getProducer().sendMessageAsync(scServerId, message);
            }
            throw UnrecoverableException.create((String)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\u4e14\u4e0d\u53ef\u91cd\u65b0\u53d1\u9001", (Throwable)e);
        }
    }
}

