/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.api;

import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JsonMapper;
import com.xdja.rcs.sc.client.api.UnrecoverableMessageLogger;
import com.xdja.rcs.sc.client.core.config.node.ScServerNode;
import com.xdja.rcs.sc.core.bean.Message;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jUnrecoverableMessageLogger
implements UnrecoverableMessageLogger {
    private static final Logger logger = LoggerFactory.getLogger(Slf4jUnrecoverableMessageLogger.class);

    @Override
    public void log(ScServerNode server, String reason) {
        logger.info(this.build(server, null, reason));
    }

    @Override
    public void log(ScServerNode server, Message msg, String reason) {
        logger.info(this.build(server, msg, reason));
    }

    @Override
    public void log(ScServerNode server, Throwable reason) {
        logger.info(this.build(server, null, reason));
    }

    @Override
    public void log(ScServerNode server, Message msg, Throwable reason) {
        logger.info(this.build(server, msg, reason));
    }

    private String build(ScServerNode server, Message msg, String reason) {
        StringBuffer content = new StringBuffer();
        content.append("\n==============================================\n\n");
        content.append(String.format("\u76ee\u7684sever\uff1aid=%s\uff0caddr=%s\uff0cport=%s\n", server.getId(), server.getAddr(), server.getPort()));
        if (null != msg) {
            try {
                content.append(String.format("\u4e22\u5f03\u7684\u6d88\u606f\u5185\u5bb9\uff1a%s\n", JsonMapper.alwaysMapper().toJson((Object)msg)));
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        content.append(String.format("\u4e0d\u53ef\u6062\u590d\u539f\u56e0\uff1a%s\n", reason));
        content.append("==============================================");
        return content.toString();
    }

    private String build(ScServerNode server, Message msg, Throwable reason) {
        StringWriter stringWriter = new StringWriter();
        reason.printStackTrace(new PrintWriter(stringWriter));
        return this.build(server, msg, stringWriter.getBuffer().toString());
    }
}

