/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.core;

import com.xdja.rcs.sc.client.core.config.ScClientConfigProxy;
import com.xdja.rcs.sc.client.core.config.node.ScServerNode;
import com.xdja.rcs.sc.client.core.consumer.Consumer;
import com.xdja.rcs.sc.client.core.producer.Producer;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.BindException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScClient {
    public static final ScClient instance = new ScClient();
    private static final Logger logger = LoggerFactory.getLogger(ScClient.class);
    private Consumer consumer = null;
    private Producer producer = null;
    private boolean initialized = false;

    public static final ScClient getInstance() {
        return instance;
    }

    private ScClient() {
    }

    public synchronized void initClient(File configFile) throws UnrecoverableException {
        try {
            this.initClient(new FileInputStream(configFile));
        }
        catch (FileNotFoundException e) {
            throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u6307\u5b9a\u7684\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
        }
    }

    private void initClient(InputStream configFileInputStream) throws UnrecoverableException {
        this.initialized = false;
        ScClientConfigProxy.initScClientConfig(configFileInputStream);
        if (ScClientConfigProxy.getScServers().isEmpty()) {
            logger.warn("\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u89e3\u6790\u51fa\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u751f\u4ea7\u8005\u89d2\u8272");
        } else {
            this.initProducer(ScClientConfigProxy.getScServers());
        }
        if (null == ScClientConfigProxy.getConsumer()) {
            logger.warn("\u4ece\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u89e3\u6790\u51fa\u6d88\u8d39\u8005\u89d2\u8272\u4fe1\u606f\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u6d88\u8d39\u8005\u89d2\u8272");
        } else {
            this.initConsumer();
        }
        this.initialized = true;
    }

    private void initConsumer() throws UnrecoverableException {
        if (null == ScClientConfigProxy.getQueueConfig()) {
            throw UnrecoverableException.create((String)"\u521d\u59cb\u5316\u6d88\u606f\u961f\u5217\u5931\u8d25\uff1a\u672a\u627e\u5230\u6d88\u606f\u961f\u5217\u914d\u7f6e\u4fe1\u606f");
        }
        try {
            this.consumer = new Consumer();
        }
        catch (BindException e) {
            throw UnrecoverableException.create((String)"\u521d\u59cb\u5316\u6d88\u8d39\u8005\u5931\u8d25\uff1a\u7aef\u53e3\u88ab\u5360\u7528", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw UnrecoverableException.create((String)"\u521d\u59cb\u5316\u6d88\u8d39\u8005\u5931\u8d25\uff1a\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        catch (Throwable t) {
            throw UnrecoverableException.create((String)"\u521d\u59cb\u5316\u6d88\u8d39\u8005\u5931\u8d25\uff1a\u672a\u77e5\u5f02\u5e38", (Throwable)t);
        }
    }

    private void initProducer(Map<String, ScServerNode> scServers) throws UnrecoverableException {
        this.producer = new Producer(scServers);
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

