/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.core.consumer;

import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.cacheableQueue.exception.QueueCacheAccessFailureException;
import com.xdja.platform.cacheableQueue.exception.UnknownElementClassException;
import com.xdja.platform.singleton.thread.SingleThreadFactory;
import com.xdja.platform.util.json.JSONException;
import com.xdja.rcs.sc.client.core.config.ScClientConfigProxy;
import com.xdja.rcs.sc.client.core.consumer.ConsumerRemotingServerCallback;
import com.xdja.rcs.sc.client.core.consumer.MessageCallback;
import com.xdja.rcs.sc.client.core.consumer.MessageConsumeThread;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.rcs.sc.queue.ScMessageQueueFactory;
import com.xdja.rcs.sc.queue.config.QueueNode;
import com.xdja.rcs.sc.remoting.RemotingServerCallback;
import com.xdja.rcs.sc.remoting.api.RemotingAPI;
import java.net.BindException;
import java.util.concurrent.ConcurrentHashMap;

public class Consumer {
    private final ConcurrentHashMap<String, MessageCallback> msgCallbackTable = new ConcurrentHashMap(5);

    public Consumer() throws BindException, InterruptedException, UnrecoverableException {
        RemotingAPI.shutdownServer();
        RemotingAPI.startServer((String)ScClientConfigProxy.getConsumer().getAddr(), (int)ScClientConfigProxy.getConsumer().getPort(), (RemotingServerCallback)new ConsumerRemotingServerCallback());
    }

    public void addMsgCallback(MessageCallback ... msgCallbacks) throws UnrecoverableException {
        if (null != msgCallbacks) {
            for (MessageCallback callback : msgCallbacks) {
                try {
                    CacheableQueue queue = ScMessageQueueFactory.getQueue((String)callback.getTopicId(), (QueueNode)ScClientConfigProxy.getQueueConfig());
                    queue.recover();
                }
                catch (UnknownElementClassException e) {
                }
                catch (QueueCacheAccessFailureException e) {
                    throw UnrecoverableException.create((String)"\u521d\u59cb\u6d88\u606f\u56de\u8c03\u5b9e\u73b0\u5931\u8d25\uff1a\u961f\u5217\u7f13\u5b58\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
                }
                catch (JSONException e) {
                    throw UnrecoverableException.create((String)("\u521d\u59cb\u6d88\u606f\u56de\u8c03\u5b9e\u73b0\u5931\u8d25\uff1a\u6062\u590d/\u521b\u5efa\u4e3b\u9898\"" + callback.getTopicId() + "\"\u7684\u961f\u5217\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
                }
                SingleThreadFactory.run(MessageConsumeThread.class, (String)callback.getTopicId());
                this.msgCallbackTable.put(callback.getTopicId(), callback);
            }
        }
    }

    public MessageCallback getMessageCallback(String topicId) {
        return this.msgCallbackTable.get(topicId);
    }
}

