/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.core.consumer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.cacheableQueue.exception.QueueCacheAccessFailureException;
import com.xdja.platform.cacheableQueue.exception.UninitializedException;
import com.xdja.platform.cacheableQueue.exception.UnknownElementClassException;
import com.xdja.platform.singleton.thread.SingleThreadFactory;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.rcs.sc.client.core.config.ScClientConfigProxy;
import com.xdja.rcs.sc.client.core.consumer.MessageConsumeThread;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.bean.MessageResponse;
import com.xdja.rcs.sc.queue.ScMessageQueueFactory;
import com.xdja.rcs.sc.queue.config.QueueNode;
import com.xdja.rcs.sc.remoting.RemotingServerCallback;
import com.xdja.rcs.sc.remoting.protocol.RemotingData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerRemotingServerCallback
implements RemotingServerCallback {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Long> msgOrderCache = new ConcurrentHashMap<String, Long>();

    public RemotingData callWithResponse(RemotingData request) {
        MessageResponse response;
        block12: {
            response = new MessageResponse();
            try {
                Message message = (Message)JSONUtil.toJavaBean((byte[])request.getContent(), (TypeReference)new TypeReference<Message>(){});
                if (StringUtils.isBlank((CharSequence)message.getTopicId())) {
                    response.setReason("\u53d1\u9001\u7684\u6d88\u606f\u4e2d\u4e0d\u5305\u542b\u4e3b\u9898\u6807\u8bc6");
                    break block12;
                }
                if (this.msgOrderCache.containsKey(message.getTopicId()) && message.getOrder() <= this.msgOrderCache.get(message.getTopicId())) {
                    this.logger.debug("\u6d88\u606f{}\u5df2\u7ecf\u88ab\u63a5\u6536\u5e76\u5904\u7406\u8fc7", (Object)message.getMsgId());
                } else {
                    CacheableQueue queue = ScMessageQueueFactory.getQueue((String)message.getTopicId(), (QueueNode)ScClientConfigProxy.getQueueConfig());
                    try {
                        queue.put((Object)message);
                    }
                    catch (UninitializedException e) {
                        this.logger.warn("\u4e3b\u9898{}\u5bf9\u5e94\u7684\u6d88\u8d39\u961f\u5217\u672a\u521d\u59cb\u5316\uff0c\u91cd\u65b0\u8fdb\u884c\u521d\u59cb\u5316", (Object)message.getTopicId());
                        queue.recover();
                        queue.put((Object)message);
                    }
                    SingleThreadFactory.run(MessageConsumeThread.class, (String)message.getTopicId());
                    this.msgOrderCache.put(message.getTopicId(), message.getOrder());
                    this.logger.debug("\u6536\u5230\u8ba2\u9605\u4e2d\u5fc3\u8def\u7531\u7684\u4e3b\u9898\u4e3a\"{}\"\u7684\u6d88\u606f\"{}\",\u5e76\u52a0\u5165\u5bf9\u5e94\u7684\u6d88\u8d39\u961f\u5217\u6210\u529f", (Object)message.getTopicId(), (Object)message.getMsgId());
                }
                response.setSuccess(true);
                response.setTopicId(message.getTopicId());
                response.setMsgId(message.getMsgId());
            }
            catch (UnknownElementClassException e) {
            }
            catch (JSONException e) {
                this.logger.error("\u6d88\u606f\u4ecebyte[]\u8f6c\u6362\u4e3aMessage\u5931\u8d25", (Throwable)e);
                response.setReason("\u6d88\u606f\u4ecebyte[]\u8f6c\u6362\u4e3aMessage\u5931\u8d25");
            }
            catch (UninitializedException e) {
                this.logger.error("\u6d88\u8d39\u961f\u5217\u6a21\u5757\u672a\u521d\u59cb\u5316", (Throwable)e);
                response.setReason("\u6d88\u8d39\u961f\u5217\u6a21\u5757\u672a\u521d\u59cb\u5316");
            }
            catch (QueueCacheAccessFailureException e) {
                this.logger.error("\u6d88\u8d39\u961f\u5217\u7f13\u5b58\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
                response.setReason("\u6d88\u8d39\u961f\u5217\u7f13\u5b58\u8bbf\u95ee\u5f02\u5e38");
            }
        }
        try {
            return RemotingData.createResponse((byte[])JSONUtil.toJSONBytes((Object)response));
        }
        catch (JSONException e) {
            this.logger.error("\u54cd\u5e94\u6570\u636e\u4eceMessageResponse\u8f6c\u6362\u4e3abyte[]\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public void callWithoutResponse(RemotingData request) {
    }
}

