/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.core.consumer;

import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.cacheableQueue.exception.QueueCacheAccessFailureException;
import com.xdja.platform.cacheableQueue.exception.UnknownElementClassException;
import com.xdja.rcs.sc.alarm.AlarmHelper;
import com.xdja.rcs.sc.client.core.ScClient;
import com.xdja.rcs.sc.client.core.config.ScClientConfigProxy;
import com.xdja.rcs.sc.client.core.consumer.MessageCallback;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.queue.ScMessageQueueFactory;
import com.xdja.rcs.sc.queue.config.QueueNode;

public final class MessageConsumeThread
implements Runnable {
    private final int retryInterval = 5000;
    private final int retryCount = 24;
    protected int retryTimes = 0;
    private CacheableQueue<Message> queue;
    private String tag = null;

    public void setTag(String tag) {
        this.tag = tag;
        try {
            this.queue = ScMessageQueueFactory.getQueue((String)tag, (QueueNode)ScClientConfigProxy.getQueueConfig());
        }
        catch (UnknownElementClassException e) {
        }
        catch (QueueCacheAccessFailureException queueCacheAccessFailureException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Message message = null;
        MessageCallback msgCallback = null;
        while (true) {
            try {
                while (true) {
                    if (null != (message = (Message)this.queue.take())) {
                        msgCallback = ScClient.getInstance().getConsumer().getMessageCallback(this.tag);
                        if (null != msgCallback) {
                            if (!msgCallback.process(message)) {
                                this.retry(message, 5000);
                                continue;
                            }
                            this.retryTimes = 0;
                            continue;
                        }
                        this.retry(message, 60000);
                        continue;
                    }
                    this.retryTimes = 0;
                }
            }
            catch (Throwable t) {
                if (null == message) continue;
                this.retry(message, 5000);
                continue;
            }
            break;
        }
    }

    private void retry(Message message, int retryInterval) {
        try {
            this.queue.put4FirstTaking((Object)message);
            if (this.retryTimes++ >= 24) {
                AlarmHelper.sendAlarmEmail((String)("\u544a\u8b66\u5185\u5bb9\uff1a\u8ba2\u9605\u4e2d\u5fc3\u5ba2\u6237\u7aef\u56de\u8c03\u4e3b\u9898\u6807\u8bc6\u4e3a\"" + this.tag + "\"\u7684\u4e1a\u52a1\u5904\u7406\u5b9e\u73b0\u5931\u8d25"));
                this.retryTimes = 0;
            }
        }
        catch (Throwable t1) {
            // empty catch block
        }
        try {
            Thread.sleep(retryInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

