/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.core.producer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.cacheableQueue.exception.QueueCacheAccessFailureException;
import com.xdja.platform.cacheableQueue.exception.UninitializedException;
import com.xdja.platform.cacheableQueue.exception.UnknownElementClassException;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.rcs.sc.client.core.config.ScClientConfigProxy;
import com.xdja.rcs.sc.client.core.config.node.ScServerNode;
import com.xdja.rcs.sc.client.core.producer.SendMessageAsync;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.bean.MessageResponse;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.rcs.sc.queue.ScMessageQueueFactory;
import com.xdja.rcs.sc.queue.config.QueueNode;
import com.xdja.rcs.sc.remoting.api.RemotingAPI;
import com.xdja.rcs.sc.remoting.exception.RemotingConnectException;
import com.xdja.rcs.sc.remoting.exception.RemotingSendRequestException;
import com.xdja.rcs.sc.remoting.exception.RemotingTimeoutException;
import com.xdja.rcs.sc.remoting.protocol.RemotingData;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Producer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, ScServerNode> scServers;

    public Producer(Map<String, ScServerNode> scServers) throws UnrecoverableException {
        this.scServers = scServers;
        this.initQueueThreadPool(scServers.values());
    }

    public String calculateMsgId(String serverId) throws UnrecoverableException {
        if (!this.scServers.containsKey(serverId)) {
            throw UnrecoverableException.create((String)("\u83b7\u53d6\u6d88\u606f\u6807\u8bc6\u5931\u8d25\uff1a\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u6807\u8bc6\"" + serverId + "\"\u5bf9\u5e94\u7684\u4fe1\u606f\u4e0d\u5b58\u5728"));
        }
        String msgId = this.scServers.get(serverId).getAppId() + "_" + UUID.randomUUID().toString().replaceAll("-", "");
        return msgId;
    }

    public void sendMessage(String scServerId, Message message) throws UnrecoverableException, RemotingSendRequestException, IllegalArgumentException {
        ScServerNode server = this.scServers.get(scServerId);
        if (server == null) {
            throw UnrecoverableException.create((String)("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u672a\u627e\u5230\"" + scServerId + "\"\u5bf9\u5e94\u7684\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u4fe1\u606f"));
        }
        if (StringUtils.isBlank((CharSequence)server.getAddr())) {
            throw new IllegalArgumentException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\"" + scServerId + "\"\u5bf9\u5e94\u7684\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u4fe1\u606f\u4e2d\u7f3a\u5c11addr");
        }
        if (StringUtils.isBlank((CharSequence)server.getAppId())) {
            throw new IllegalArgumentException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\"" + scServerId + "\"\u5bf9\u5e94\u7684\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u4fe1\u606f\u4e2d\u7f3a\u5c11appId(\u751f\u4ea7\u8005\u6807\u8bc6)");
        }
        if (StringUtils.isBlank((CharSequence)message.getMsgId())) {
            message.setMsgId(this.calculateMsgId(scServerId));
        }
        try {
            message.setProducer(server.getAppId());
            RemotingData response = RemotingAPI.sendData((String)server.getAddr(), (int)server.getPort(), (byte[])JSONUtil.toJSONBytes((Object)message));
            MessageResponse msgResp = (MessageResponse)JSONUtil.toJavaBean((byte[])response.getContent(), (TypeReference)new TypeReference<MessageResponse>(){});
            if (!msgResp.isSuccess()) {
                throw new RemotingSendRequestException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a" + msgResp.getReason(), msgResp.isRecoverable());
            }
            this.logger.debug("\u4e3b\u9898\u4e3a{}\u7684\u6d88\u606f{}\u53d1\u9001\u6210\u529f", (Object)message.getTopicId(), (Object)message.getMsgId());
        }
        catch (JSONException e) {
            throw new RemotingSendRequestException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1ajson\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new RemotingSendRequestException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38", (Throwable)e, true);
        }
        catch (RemotingConnectException e) {
            throw new RemotingSendRequestException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u8fde\u63a5\u670d\u52a1\u7aef\u5931\u8d25", (Throwable)e, true);
        }
        catch (RemotingTimeoutException e) {
            throw new RemotingSendRequestException("\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff1a\u7b49\u5f85\u670d\u52a1\u7aef\u8fd4\u56de\u54cd\u5e94\u6570\u636e\u8d85\u65f6", (Throwable)e, true);
        }
    }

    public void sendMessageAsync(String scServerId, Message message) throws UnrecoverableException {
        try {
            CacheableQueue queue = ScMessageQueueFactory.getQueue((String)scServerId, (QueueNode)ScClientConfigProxy.getQueueConfig());
            queue.put((Object)message);
        }
        catch (UnknownElementClassException e) {
        }
        catch (QueueCacheAccessFailureException e) {
            throw UnrecoverableException.create((String)"\u961f\u5217\u7f13\u5b58\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
        }
        catch (UninitializedException e) {
            throw UnrecoverableException.create((String)"\u961f\u5217\u6a21\u5757\u672a\u521d\u59cb\u5316\u3002", (Throwable)e);
        }
        catch (JSONException e) {
            throw UnrecoverableException.create((String)"\u628a\u6d88\u606f\u8f6c\u6362\u4e3ajson\u5b57\u7b26\u4e32\u5931\u8d25", (Throwable)e);
        }
    }

    private void initQueueThreadPool(Collection<ScServerNode> nodes) throws UnrecoverableException {
        ExecutorService executor = Executors.newFixedThreadPool(nodes.size());
        ScServerNode scServerNode2 = null;
        CacheableQueue queue = null;
        for (ScServerNode scServerNode2 : nodes) {
            try {
                queue = ScMessageQueueFactory.getQueue((String)scServerNode2.getId(), (QueueNode)ScClientConfigProxy.getQueueConfig());
                queue.recover();
            }
            catch (UnknownElementClassException e) {
                throw UnrecoverableException.create((String)"\u521d\u59cb\u6d88\u606f\u961f\u5217\u5931\u8d25\uff1a\u961f\u5217\u4e2d\u5143\u7d20\u7684\u6240\u5c5e\u5bf9\u8c61\u4e0e\u961f\u5217\u6807\u8bc6\u6240\u5bf9\u5e94\u7684\u961f\u5217\u521d\u6b21\u521b\u5efa\u65f6\u4e0d\u4e00\u81f4", (Throwable)e);
            }
            catch (QueueCacheAccessFailureException e) {
                throw UnrecoverableException.create((String)"\u521d\u59cb\u6d88\u606f\u961f\u5217\u5931\u8d25\uff1a\u961f\u5217\u7f13\u5b58\u8bbf\u95ee\u5f02\u5e38", (Throwable)e);
            }
            catch (JSONException e) {
                throw UnrecoverableException.create((String)("\u521d\u59cb\u6d88\u606f\u961f\u5217\u5931\u8d25\uff1a\u6062\u590d/\u521b\u5efa\u6d88\u606f\"" + scServerNode2.getId() + "\"\u7684\u961f\u5217\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            }
            this.logger.debug("\u5f00\u59cb\u542f\u52a8\u5f02\u6b65\u53d1\u9001\u6d88\u606f\u7ebf\u7a0b...");
            executor.execute(new SendMessageAsync((CacheableQueue<Message>)queue, scServerNode2));
        }
    }
}

