/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.client.core.producer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.platform.cacheableQueue.CacheableQueue;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.rcs.sc.alarm.AlarmHelper;
import com.xdja.rcs.sc.client.api.ScClientAPI;
import com.xdja.rcs.sc.client.core.config.node.ScServerNode;
import com.xdja.rcs.sc.core.bean.Message;
import com.xdja.rcs.sc.core.bean.MessageResponse;
import com.xdja.rcs.sc.remoting.api.RemotingAPI;
import com.xdja.rcs.sc.remoting.protocol.RemotingData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageAsync
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private CacheableQueue<Message> queue;
    private final int retryInterval = 5000;
    private final int retryCount = 24;
    protected int retryTimes = 0;
    private ScServerNode server;

    public SendMessageAsync(CacheableQueue<Message> queue, ScServerNode scServer) {
        this.queue = queue;
        this.server = scServer;
    }

    @Override
    public void run() {
        String scServerId = this.server.getId();
        Message message = null;
        while (true) {
            try {
                while (true) {
                    if (null == (message = (Message)this.queue.take())) {
                        continue;
                    }
                    RemotingData response = RemotingAPI.sendData((String)this.server.getAddr(), (int)this.server.getPort(), (byte[])JSONUtil.toJSONBytes((Object)message));
                    if (null != response) {
                        MessageResponse msgResp = (MessageResponse)JSONUtil.toJavaBean((byte[])response.getContent(), (TypeReference)new TypeReference<MessageResponse>(){});
                        if (msgResp.isSuccess()) {
                            this.retryTimes = 0;
                        } else if (msgResp.isRecoverable()) {
                            this.logger.error("\u53d1\u9001\u6d88\u606f\u5230SC\"{}\"\u5931\u8d25\uff0c\u4f46\u53ef\u4ee5\u91cd\u65b0\u53d1\u9001\uff0c\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)scServerId, (Object)msgResp.getReason());
                            this.retry(message);
                        } else {
                            ScClientAPI.logUnrecoverableMsg(this.server, message, msgResp.getReason());
                            this.logger.error("\u53d1\u9001\u6d88\u606f\u5230SC\"{}\"\u5931\u8d25\u4e14\u4e0d\u53ef\u91cd\u65b0\u53d1\u9001\uff0c\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)scServerId, (Object)msgResp.getReason());
                            this.retryTimes = 0;
                        }
                    }
                    this.logger.debug("\u4e3b\u9898\u4e3a{}\u7684\u6d88\u606f{}\u53d1\u9001\u6210\u529f", (Object)message.getTopicId(), (Object)message.getMsgId());
                }
            }
            catch (JSONException e) {
                ScClientAPI.logUnrecoverableMsg(this.server, message, e);
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5230SC\"" + scServerId + "\"\u5931\u8d25\u4e14\u4e0d\u53ef\u91cd\u65b0\u53d1\u9001", (Throwable)e);
                continue;
            }
            catch (Throwable t) {
                if (null == message) continue;
                this.logger.error("\u53d1\u9001\u6d88\u606f\u5230SC\"" + scServerId + "\"\u5931\u8d25\uff0c\u5c1d\u8bd5\u91cd\u65b0\u53d1\u9001", t);
                this.retry(message);
                continue;
            }
            break;
        }
    }

    private void retry(Message message) {
        try {
            this.queue.put4FirstTaking((Object)message);
            if (this.retryTimes++ >= 24) {
                AlarmHelper.sendAlarmEmail((String)("\u544a\u8b66\u5185\u5bb9\uff1a\u751f\u4ea7\u8005\u53d1\u9001\u6d88\u606f\u5230SC\"" + this.server.getId() + "\"\u5931\u8d25"));
                this.retryTimes = 0;
            }
        }
        catch (Throwable e) {
            String msg = String.format("\u4e3b\u9898\u4e3a\"{}\"\u7684\u6d88\u606f\"{}\"\u91cd\u65b0\u653e\u56de\u8def\u7531\u961f\u5217\u5931\u8d25", message.getTopicId(), message.getMsgId());
            ScClientAPI.logUnrecoverableMsg(this.server, message, new Exception(msg, e));
            this.logger.error(msg, e);
        }
        try {
            this.getClass();
            Thread.sleep(5000L);
        }
        catch (Throwable e) {
            this.logger.warn("\u6d88\u606f\u91cd\u8bd5\u65f6\u7ebf\u7a0b\u4f11\u7720\u5931\u8d25");
        }
    }
}

