/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.rcs.sc.server;

import com.xdja.platform.file.monitor.FileListener;
import com.xdja.platform.file.monitor.FileMonitor;
import com.xdja.rcs.sc.alarm.AlarmHelper;
import com.xdja.rcs.sc.core.exception.UnrecoverableException;
import com.xdja.rcs.sc.remoting.RemotingServerCallback;
import com.xdja.rcs.sc.remoting.api.RemotingAPI;
import com.xdja.rcs.sc.server.ScServerRemotingServerCallback;
import com.xdja.rcs.sc.server.config.AlarmOperator;
import com.xdja.rcs.sc.server.config.ScServerConfigProxy;
import com.xdja.rcs.sc.server.process.MessageProcessor;
import com.xdja.rcs.sc.server.route.MessageRouter;
import com.xdja.ucm.client.jmx.StaticValue;
import com.xdja.ucm.client.jmx.operator.IJMXOperator;
import com.xdja.ucm.client.jmx.server.JMXServer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.BindException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String clientConfigFile = "sc_server_config.json";
    private final String ucmConfigFile = "ucm-client.properties";
    private boolean initialized = false;

    public synchronized void init(String configFileDir) throws UnrecoverableException {
        if (!configFileDir.endsWith(File.separator)) {
            configFileDir = configFileDir + File.separator;
        }
        this.initServer(new File(configFileDir, "sc_server_config.json"));
        this.initAlarmFromUCM(new File(configFileDir, "ucm-client.properties"));
    }

    private synchronized void initServer(final File configFile) throws UnrecoverableException {
        if (null == configFile) {
            throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a");
        }
        if (configFile.exists() && configFile.isDirectory()) {
            throw UnrecoverableException.create((String)("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a" + configFile.getAbsolutePath() + "\u662f\u6587\u4ef6\u5939\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002"));
        }
        if (!this.initialized) {
            try {
                MessageProcessor.getInstance().init();
                this.initServer(new FileInputStream(configFile));
                FileMonitor.getInstance().start(configFile.getPath(), new FileListener(){

                    public void onChanged(String fileName) {
                        try {
                            ScServer.this.initServer(new FileInputStream(configFile));
                        }
                        catch (FileNotFoundException e) {
                            ScServer.this.logger.error("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
                            AlarmHelper.sendAlarmEmail((String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25", (String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u914d\u7f6e\u6587\u4ef6\uff08sc_server_config.json\uff09\u4e0d\u5b58\u5728");
                        }
                        catch (UnrecoverableException e) {
                            ScServer.this.logger.error("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
                            AlarmHelper.sendAlarmEmail((String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25", (String)e.getStackTraceInfo());
                        }
                    }
                }, 10000L);
            }
            catch (FileNotFoundException e) {
                throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u914d\u7f6e\u6587\u4ef6\uff08sc_server_config.json\uff09\u4e0d\u5b58\u5728", (Throwable)e);
            }
        }
    }

    private void initServer(InputStream configFileInputStream) throws UnrecoverableException {
        this.initialized = false;
        ScServerConfigProxy.initScServerConfig(configFileInputStream);
        MessageRouter.getInstance().init();
        try {
            RemotingAPI.shutdownServer();
            RemotingAPI.startServer((String)ScServerConfigProxy.getScServer().getAddr(), (int)ScServerConfigProxy.getScServer().getPort(), (RemotingServerCallback)new ScServerRemotingServerCallback());
        }
        catch (BindException e) {
            throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u7aef\u53e3\u88ab\u5360\u7528", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        catch (Throwable t) {
            throw UnrecoverableException.create((String)"\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\u7aef\u521d\u59cb\u5316\u5931\u8d25\uff1a\u672a\u77e5\u5f02\u5e38", (Throwable)t);
        }
        this.initialized = true;
    }

    private void initAlarmFromUCM(File ucmConfigFile) {
        HashMap<String, String> ucmClientParameter = new HashMap<String, String>();
        Properties ucmProperties = new Properties();
        this.logger.debug("\u52a0\u8f7dUCM\u914d\u7f6e\u6587\u4ef6:{}", (Object)ucmConfigFile.getAbsoluteFile());
        try {
            ucmProperties.load(new FileInputStream(ucmConfigFile));
            Set<String> keys = ucmProperties.stringPropertyNames();
            String key2 = null;
            for (String key2 : keys) {
                ucmClientParameter.put(key2, ucmProperties.getProperty(key2));
            }
            this.logger.debug("\u542f\u52a8UCM\u5ba2\u6237\u7aef,\u542f\u52a8\u53c2\u6570:{}", (Object)((Object)ucmClientParameter).toString());
            JMXServer.start((IJMXOperator)new AlarmOperator(), ucmClientParameter);
        }
        catch (FileNotFoundException e) {
            this.logger.warn("\u521d\u59cb\u5316\u544a\u8b66\u6a21\u5757\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001\u544a\u8b66\uff1aUCM\u914d\u7f6e\uff08{}\uff09\u6587\u4ef6\u4e0d\u5b58\u5728", (Object)ucmConfigFile);
            return;
        }
        catch (Exception e) {
            this.logger.warn("\u521d\u59cb\u5316\u544a\u8b66\u6a21\u5757\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001\u544a\u8b66\uff1a{}", (Object)e.getMessage());
            return;
        }
        try {
            String alarmConfig = (String)StaticValue.getData((String)"sc.alarm.config");
            if (StringUtils.isBlank((CharSequence)alarmConfig)) {
                this.logger.debug("\u672a\u83b7\u53d6\u5230\u544a\u8b66\u914d\u7f6e\u4fe1\u606f\u3002");
                return;
            }
            this.logger.debug("\u83b7\u53d6\u544a\u8b66\u914d\u7f6e\u4fe1\u606f:key={}, value={}", (Object)"sc.alarm.config", (Object)alarmConfig);
            this.initAlarm(new ByteArrayInputStream(alarmConfig.getBytes()));
        }
        catch (Exception e) {
            this.logger.warn("\u521d\u59cb\u5316\u544a\u8b66\u6a21\u5757\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001\u544a\u8b66\uff1a{}", (Object)e.getMessage());
        }
    }

    private void initAlarm(InputStream configFileInputStream) {
        try {
            AlarmHelper.init((InputStream)configFileInputStream);
        }
        catch (UnrecoverableException e) {
            this.logger.warn("\u521d\u59cb\u5316\u544a\u8b66\u6a21\u5757\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001\u544a\u8b66\uff1a" + e.getMessage());
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

